/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.lsp4jakarta.commons.JakartaJavaProjectLabelsParams;
import org.eclipse.lsp4jakarta.commons.ProjectLabelInfoEntry;
import org.eclipse.lsp4jakarta.jdt.core.ProjectLabelDefinition;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.JDTJakartaUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ProjectLabelRegistry;

public class ProjectLabelManager {
    private static final ProjectLabelManager INSTANCE = new ProjectLabelManager();

    public static ProjectLabelManager getInstance() {
        return INSTANCE;
    }

    private ProjectLabelManager() {
    }

    public List<ProjectLabelInfoEntry> getProjectLabelInfo() {
        IProject[] projects;
        ArrayList<ProjectLabelInfoEntry> results = new ArrayList<ProjectLabelInfoEntry>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            ProjectLabelInfoEntry info = this.getProjectLabelInfo(project, null);
            if (info != null) {
                results.add(info);
            }
            ++n2;
        }
        return results;
    }

    private ProjectLabelInfoEntry getProjectLabelInfo(IProject project, List<String> types) {
        String uri = JDTJakartaUtils.getProjectURI(project);
        if (uri != null) {
            return new ProjectLabelInfoEntry(uri, project.getName(), this.getProjectLabels(project, types));
        }
        return null;
    }

    public ProjectLabelInfoEntry getProjectLabelInfo(JakartaJavaProjectLabelsParams params, IJDTUtils utils, IProgressMonitor monitor) {
        IProject project = ProjectLabelManager.findProject(params.getUri(), utils);
        if (project == null) {
            return ProjectLabelInfoEntry.EMPTY_PROJECT_INFO;
        }
        return this.getProjectLabelInfo(project, params.getTypes());
    }

    private static IProject findProject(String uri, IJDTUtils utils) {
        if (uri.startsWith("jdt://jarentry")) {
            URI jarEntryUri = URI.create(uri);
            String rootId = jarEntryUri.getQuery();
            IPackageFragmentRoot packageRoot = (IPackageFragmentRoot)JavaCore.create((String)rootId);
            if (packageRoot != null) {
                IJavaProject javaProject = packageRoot.getJavaProject();
                return javaProject != null ? javaProject.getProject() : null;
            }
            return null;
        }
        IFile file = utils.findFile(uri);
        return file != null ? file.getProject() : null;
    }

    private List<String> getProjectLabels(IProject project, List<String> types) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return Collections.emptyList();
        }
        ArrayList<String> projectLabels = new ArrayList<String>();
        List<ProjectLabelDefinition> definitions = ProjectLabelRegistry.getInstance().getProjectLabelDefinitions();
        for (ProjectLabelDefinition definition : definitions) {
            projectLabels.addAll(definition.getProjectLabels(javaProject));
        }
        if (types != null) {
            for (String type : types) {
                if (JDTTypeUtils.findType(javaProject, type) == null) continue;
                projectLabels.add(type);
            }
        }
        return projectLabels;
    }
}

