/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.java;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public class ManagedBean {
    public static final String MANAGED_BEAN_ANNOTATION = "javax.annotation.ManagedBean";
    public static final String VETOED_ANNOTATION = "jakarta.enterprise.inject.Vetoed";
    public static final String DECORATOR_ANNOTATION = "jakarta.decorator.Decorator";
    public static final String INJECT_ANNOTATION = "jakarta.inject.Inject";
    public static final String EXTENSION_SERVICE_IFACE = "jakarta.enterprise.inject.spi.Extension";

    public static boolean isManagedBean(IType type) throws JavaModelException {
        if (ManagedBean.isInnerClass(type)) {
            return false;
        }
        if (ManagedBean.isAbstractClass(type) && !ManagedBean.isAnnotatedClass(type, DECORATOR_ANNOTATION)) {
            return false;
        }
        if (ManagedBean.implementsExtends(type, EXTENSION_SERVICE_IFACE)) {
            return false;
        }
        if (ManagedBean.isAnnotatedClass(type, VETOED_ANNOTATION) || ManagedBean.isPackageMetadataAnnotated(type, VETOED_ANNOTATION)) {
            return false;
        }
        return ManagedBean.containsValidConstructor(type);
    }

    public static boolean isManagedBean(ILocalVariable variable) throws JavaModelException {
        IType variableType = ManagedBean.variableSignatureToType(variable);
        return ManagedBean.isManagedBean(variableType);
    }

    public static IType variableSignatureToType(ILocalVariable variable) {
        IType varType = null;
        IMember declaringMember = variable.getDeclaringMember();
        if (declaringMember != null) {
            IType declaringType = declaringMember.getDeclaringType();
            try {
                String typeSig = variable.getTypeSignature();
                String typeName = Signature.toString((String)typeSig);
                varType = ManagedBean.getChildITypeByName(declaringType, typeName);
                if (varType == null) {
                    IJavaProject jProject = declaringType.getJavaProject();
                    varType = jProject.findType(typeName);
                    String sn = Signature.toString((String)typeSig);
                    varType = declaringType.getType(sn);
                }
            }
            catch (Exception e) {
                JakartaCorePlugin.logException("Unable to convert an ILocalVariable to IType", e);
            }
        }
        return varType;
    }

    public static boolean isInnerClass(IType type) throws JavaModelException {
        return type.isMember() && !Flags.isStatic((int)type.getFlags());
    }

    public static boolean isAbstractClass(IType iType) throws JavaModelException {
        boolean isAbstractClass = Flags.isAbstract((int)iType.getFlags());
        return isAbstractClass;
    }

    public static boolean isAnnotatedClass(IType iType, String annotation) throws JavaModelException {
        IAnnotation[] annotations = iType.getAnnotations();
        int i = 0;
        while (i < annotations.length) {
            CharSequence[] annotationParts;
            String resolvedAnnotation;
            String[][] resolvedType = iType.resolveType(annotations[i].getElementName());
            if (resolvedType != null && resolvedType.length != 0 && annotation.equals(resolvedAnnotation = String.join((CharSequence)".", annotationParts = resolvedType[0]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean implementsExtends(IType type, String name) throws JavaModelException {
        IType childType;
        String resolvedClassName = ManagedBean.getFullyQualifiedClassName(type, type.getElementName());
        if (resolvedClassName != null && name.equals(resolvedClassName)) {
            return true;
        }
        String[] interfaces = type.getSuperInterfaceNames();
        int i = 0;
        while (i < interfaces.length) {
            childType = ManagedBean.getChildITypeByName(type, interfaces[i]);
            if (childType != null) {
                return ManagedBean.implementsExtends(childType, name);
            }
            ++i;
        }
        String superClass = type.getSuperclassName();
        if (superClass != null && (childType = ManagedBean.getChildITypeByName(type, superClass)) != null) {
            return ManagedBean.implementsExtends(childType, name);
        }
        return false;
    }

    public static boolean isPackageMetadataAnnotated(IType type, String annotation) {
        IPackageDeclaration packageDeclaration;
        IAnnotation foundAnnotation;
        IPackageFragment packageFragment = type.getPackageFragment();
        ICompilationUnit compilationUnit = packageFragment.getCompilationUnit("package-info.java");
        return compilationUnit.exists() && (foundAnnotation = (packageDeclaration = compilationUnit.getPackageDeclaration(packageFragment.getElementName())).getAnnotation(annotation)) != null && !foundAnnotation.exists();
    }

    public static ArrayList<IMethod> getConstructors(IType type) throws JavaModelException {
        ArrayList<IMethod> constructors = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            boolean isConstructor = methods[i].isConstructor();
            if (isConstructor) {
                constructors.add(methods[i]);
            }
            ++i;
        }
        return constructors;
    }

    public static boolean containsValidConstructor(IType type) throws JavaModelException {
        ArrayList<IMethod> constructors = ManagedBean.getConstructors(type);
        for (IMethod constructor : constructors) {
            if (constructor.getNumberOfParameters() == 0) {
                return true;
            }
            IAnnotation injectAnnotation = constructor.getAnnotation(INJECT_ANNOTATION);
            if (injectAnnotation == null || !injectAnnotation.exists()) continue;
            return true;
        }
        return false;
    }

    public static IType getChildITypeByName(IType parentType, String simpleName) throws JavaModelException {
        IType iType = null;
        String resolvedClassName = ManagedBean.getFullyQualifiedClassName(parentType, simpleName);
        if (resolvedClassName != null) {
            IJavaProject jProject = parentType.getJavaProject();
            iType = jProject.findType(resolvedClassName);
        }
        return iType;
    }

    public static String getFullyQualifiedClassName(IType parentType, String simpleName) throws JavaModelException {
        String resolvedClassName = null;
        String[][] resolvedType = parentType.resolveType(simpleName);
        if (resolvedType != null && resolvedType.length != 0) {
            CharSequence[] classParts = resolvedType[0];
            resolvedClassName = String.join((CharSequence)".", classParts);
        }
        return resolvedClassName;
    }
}

