/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.ls;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.lsp4jakarta.commons.JakartaJavaProjectLabelsParams;
import org.eclipse.lsp4jakarta.jdt.core.ProjectLabelManager;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.AbstractJakartaDelegateCommandHandler;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class JakartaJavaProjectDelegateCommandHandler
extends AbstractJakartaDelegateCommandHandler {
    private static final String PROJECT_LABELS_COMMAND_ID = "jakarta/java/projectLabels";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "jakarta/java/projectLabels": {
                return JakartaJavaProjectDelegateCommandHandler.getProjectLabelInfo(arguments, commandId, progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static Object getProjectLabelInfo(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaProjectLabelsParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaProjectLabelsParams.uri (java file URI)!", commandId));
        }
        List<String> types = ArgumentUtils.getStringList(obj, "types");
        JakartaJavaProjectLabelsParams params = new JakartaJavaProjectLabelsParams();
        params.setUri(javaFileUri);
        params.setTypes(types);
        return ProjectLabelManager.getInstance().getProjectLabelInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
    }
}

