/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.JakartaCodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ImplementInterfaceProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public class InsertImplementsClauseToImplListenerQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(InsertImplementsClauseToImplListenerQuickFix.class.getName());
    private static final String INTERFACE_TYPE_KEY = "interface.type";
    private static final String INTERFACE_NAME_KEY = "interface.name";

    @Override
    public String getParticipantId() {
        return InsertImplementsClauseToImplListenerQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ASTNode node = context.getCoveredNode();
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType != null) {
            this.createCodeAction(context, diagnostic, parentType, "ServletContextListener", "jakarta.servlet.ServletContextListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "ServletContextAttributeListener", "jakarta.servlet.ServletContextAttributeListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "ServletRequestListener", "jakarta.servlet.ServletRequestListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "ServletRequestAttributeListener", "jakarta.servlet.ServletRequestAttributeListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "HttpSessionListener", "jakarta.servlet.http.HttpSessionListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "HttpSessionAttributeListener", "jakarta.servlet.http.HttpSessionAttributeListener", codeActions);
            this.createCodeAction(context, diagnostic, parentType, "HttpSessionIdListener", "jakarta.servlet.http.HttpSessionIdListener", codeActions);
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        String interfaceName = (String)data.getExtendedDataEntry(INTERFACE_NAME_KEY);
        String interfaceType = (String)data.getExtendedDataEntry(INTERFACE_TYPE_KEY);
        String label = this.getLabel(parentType.getName(), interfaceName);
        ImplementInterfaceProposal proposal = new ImplementInterfaceProposal(label, context.getCompilationUnit(), parentType, context.getASTRoot(), interfaceType, 0);
        try {
            toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "Unable to resolve code action edit to add the implements clause to a class.", e);
        }
        return toResolve;
    }

    protected void createCodeAction(JavaCodeActionContext context, Diagnostic diagnostic, ITypeBinding parentType, String interfaceName, String interfaceType, List<CodeAction> codeActions) {
        ExtendedCodeAction codeAction = new ExtendedCodeAction(this.getLabel(parentType.getName(), interfaceName));
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(INTERFACE_NAME_KEY, interfaceName);
        extendedData.put(INTERFACE_TYPE_KEY, interfaceType);
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), JakartaCodeActionId.ServletListenerImplementation));
        codeActions.add(codeAction);
    }

    private String getLabel(String classTypeName, String interfaceName) {
        return Messages.getMessage("LetClassImplement", BasicElementLabels.getJavaElementName((String)classTypeName), BasicElementLabels.getJavaElementName((String)interfaceName));
    }
}

