/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.expression.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;

public class CompositeResourcesTest
extends TestCase {
    private XpandExecutionContext myContext;
    private StringBuilder myBuffer;
    private TestResourceManager myResourceManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.myBuffer = new StringBuilder();
        this.myResourceManager = new TestResourceManager();
        this.myContext = ContextFactory.createXpandContext((ResourceManager)this.myResourceManager, (Output)new BufferOutput(this.myBuffer), Collections.emptyList());
        this.myContext = (XpandExecutionContext)this.myContext.cloneWithVariable(new Variable[]{new Variable("this", (Object)"")});
    }

    public void testOverrideXtend() {
        this.myResourceManager.setPrefixes(new String[]{null});
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test1"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"1", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override1", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test1"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"2", (String)this.myBuffer.toString());
    }

    public void testAutomaticAdviceLoad() {
        this.myResourceManager.setPrefixes("override2", null);
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test1"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"1added", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override2", "override1", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test1"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"2added", (String)this.myBuffer.toString());
    }

    public void testRedefineInAspect() {
        this.myResourceManager.setPrefixes(new String[]{null});
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineInAspect"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineOriginal", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override2", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::testRedefineInAspect"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"testRedefineRedefined", (String)this.myBuffer.toString());
    }

    public void testOverrideXpand() {
        this.myResourceManager.setPrefixes(new String[]{null});
        XpandDefinition definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test2"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"<test4>", (String)this.myBuffer.toString());
        this.myBuffer.delete(0, this.myBuffer.length());
        this.myResourceManager.setPrefixes("override3", null);
        definition = this.myContext.findDefinition(CompositeResourcesTest.qualify("Overridable::test2"), (EClassifier)EcorePackage.eINSTANCE.getEString(), new EClassifier[0]);
        definition.evaluate(this.myContext);
        CompositeResourcesTest.assertEquals((String)"<test3>", (String)this.myBuffer.toString());
    }

    private static String qualify(String unqualified) {
        return "org::eclipse::gmf::tests::xpand::evaluate::" + unqualified;
    }

    private static class TestResourceManager
    extends ResourceManagerImpl {
        private String[] mySuffixes;

        private TestResourceManager() {
        }

        public void setPrefixes(String ... prefixes) {
            this.mySuffixes = prefixes;
            this.forgetAll();
        }

        protected boolean shouldCache() {
            return true;
        }

        protected String getAspectsTemplateName(String fullyQualifiedName) {
            return String.valueOf(fullyQualifiedName) + "_Aspects";
        }

        public Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
            ArrayList<Reader> result = new ArrayList<Reader>(this.mySuffixes.length);
            int i = 0;
            while (i < this.mySuffixes.length) {
                Reader reader;
                String templateName = String.valueOf(TypeNameUtil.getLastSegment((String)fullyQualifiedName)) + "." + extension;
                String path = TypeNameUtil.withoutLastSegment((String)fullyQualifiedName).replaceAll("::", "/");
                if (this.mySuffixes[i] != null && this.mySuffixes[i].length() > 0) {
                    path = String.valueOf(path) + "/" + this.mySuffixes[i];
                }
                if ((reader = this.getReader(path = String.valueOf(path) + "/" + templateName)) != null) {
                    result.add(reader);
                }
                ++i;
            }
            if (result.isEmpty()) {
                throw new FileNotFoundException();
            }
            return result.toArray(new Reader[result.size()]);
        }

        protected Reader getReader(String path) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            if (resourceAsStream == null) {
                return null;
            }
            return new InputStreamReader(resourceAsStream, Charset.forName("ISO-8859-1"));
        }

        protected void handleParserException(ParserException ex) {
            CompositeResourcesTest.fail((String)ex.getClass().getName());
        }
    }
}

