/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.designer.ucm.core.Activator;
import org.eclipse.papyrus.designer.ucm.core.Messages;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_commons.ApplicationModule;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.util.UCMResource;
import org.eclipse.papyrus.designer.ucm.supplement.profile.UCM_Supplement.util.UCMSuppResource;
import org.eclipse.papyrus.designer.ucm.types.profile.UCMTypes.util.UCMTypesResource;
import org.eclipse.papyrus.infra.architecture.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateUCMModelCommand
implements IModelCreationCommand {
    public void createModel(ModelSet modelSet) {
        this.runAsTransaction(modelSet);
    }

    protected void runAsTransaction(ModelSet modelSet) {
        final Resource modelResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.CreateUCMModelCommand_InitModel, Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject model = CreateUCMModelCommand.this.getRootElement(modelResource);
                CreateUCMModelCommand.this.attachModelToResource(model, modelResource);
                CreateUCMModelCommand.this.initializeModel(model);
                return CommandResult.newOKCommandResult();
            }
        };
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
    }

    protected EObject getRootElement(Resource modelResource) {
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0) {
            Object root = modelResource.getContents().get(0);
            if (root instanceof EObject) {
                rootElement = (EObject)root;
            }
        } else {
            rootElement = this.createRootElement();
        }
        return rootElement;
    }

    protected EObject createRootElement() {
        return UMLFactory.eINSTANCE.createModel();
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    protected void initializeModel(EObject owner) {
        ((Package)owner).setName(this.getModelName());
        Profile profile = (Profile)PackageUtil.loadPackage((URI)UCMResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet());
        if (profile != null) {
            PackageUtil.applyProfile((Package)((Package)owner), (Profile)profile, (boolean)true);
        } else {
            Activator.log.error(Messages.CreateUCMModelCommand_ProfileNotFound, null);
        }
        profile = (Profile)PackageUtil.loadPackage((URI)UCMSuppResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet());
        if (profile != null) {
            PackageUtil.applyProfile((Package)((Package)owner), (Profile)profile, (boolean)true);
        } else {
            Activator.log.error(Messages.CreateUCMModelCommand_ProfileSuppNotFound, null);
        }
        profile = (Profile)PackageUtil.loadPackage((URI)UCMTypesResource.PROFILE_PATH_URI, (ResourceSet)owner.eResource().getResourceSet());
        if (profile != null) {
            PackageUtil.applyProfile((Package)((Package)owner), (Profile)profile, (boolean)true);
        } else {
            Activator.log.error(Messages.CreateUCMModelCommand_ProfileTypesNotFound, null);
        }
        StereotypeUtil.apply((Element)((Element)owner), ApplicationModule.class);
    }

    protected String getModelName() {
        return "UCMModel";
    }
}

