/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DataTypeScript {
  public static CharSequence genDefaultInitialisationProtoype(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Property, Boolean> _function = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          ValueSpecification _defaultValue = it.getDefaultValue();
          return Boolean.valueOf((_defaultValue != null));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(dataType.getOwnedAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment = UmlCommentServices.partComment(dataType, "Default value initialization prototypes");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
        _builder.append("/*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Default value initialization");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ");
        CharSequence _genName = CommonScript.genName(dataType);
        _builder.append(_genName, " ");
        _builder.append(" structure instance pointer");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return void");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        CharSequence _genName_1 = CommonScript.genName(dataType);
        _builder.append(_genName_1);
        _builder.append("_init(");
        CharSequence _genName_2 = CommonScript.genName(dataType);
        _builder.append(_genName_2);
        _builder.append("* self);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genDefaultIntialisationOperation(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Property, Boolean> _function = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          ValueSpecification _defaultValue = it.getDefaultValue();
          return Boolean.valueOf((_defaultValue != null));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(dataType.getOwnedAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment = UmlCommentServices.partComment(dataType, "Default value initialization Implementation");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        CharSequence _genName = CommonScript.genName(dataType);
        _builder.append(_genName);
        _builder.append("_init(");
        CharSequence _genName_1 = CommonScript.genName(dataType);
        _builder.append(_genName_1);
        _builder.append("* self){");
        _builder.newLineIfNotEmpty();
        {
          EList<Property> _ownedAttributes = dataType.getOwnedAttributes();
          for(final Property attribute : _ownedAttributes) {
            {
              if ((((attribute.getDefaultValue() != null) && (!attribute.isStatic())) && (attribute.getType() != null))) {
                CharSequence _genInitDefaultValue = variableScript.genInitDefaultValue(attribute);
                _builder.append(_genInitDefaultValue);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence genDataTypeStructDeclarations(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = dataType.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("typedef struct ");
    CharSequence _genName = CommonScript.genName(dataType);
    _builder.append(_genName);
    _builder.append(" ");
    CharSequence _genName_1 = CommonScript.genName(dataType);
    _builder.append(_genName_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("struct ");
    CharSequence _genName_2 = CommonScript.genName(dataType);
    _builder.append(_genName_2);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      final Function1<Property, Boolean> _function = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          boolean _isStatic = it.isStatic();
          return Boolean.valueOf((!_isStatic));
        }
      };
      Iterable<Property> _filter = IterableExtensions.<Property>filter(dataType.getAllAttributes(), _function);
      for(final Property attribute : _filter) {
        CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
        _builder.append(_genVariableDeclaration);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genDataTypeStructDeclarations(final Enumeration enumeration) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = enumeration.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("typedef enum ");
    CharSequence _genName = CommonScript.genName(enumeration);
    _builder.append(_genName);
    _builder.append(" ");
    CharSequence _genName_1 = CommonScript.genName(enumeration);
    _builder.append(_genName_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("enum ");
    CharSequence _genName_2 = CommonScript.genName(enumeration);
    _builder.append(_genName_2);
    _builder.append("{");
    _builder.newLineIfNotEmpty();
    {
      EList<EnumerationLiteral> _ownedLiterals = enumeration.getOwnedLiterals();
      boolean _hasElements = false;
      for(final EnumerationLiteral literal : _ownedLiterals) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",\n", "\t");
        }
        _builder.append("\t");
        CharSequence _genName_3 = CommonScript.genName(literal);
        _builder.append(_genName_3, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genStateEnumPrototype(final StateMachine sm) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("typedef enum StateIDEnum StateIDEnum;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("enum StateIDEnum {");
    _builder.newLine();
    {
      final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
        @Override
        public Boolean apply(final State it) {
          return Boolean.valueOf((!(it instanceof FinalState)));
        }
      };
      Iterable<State> _filter = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function);
      for(final State state : _filter) {
        _builder.append("\t");
        CharSequence _genName = CommonScript.genName(state);
        _builder.append(_genName, "\t");
        _builder.append(",");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genStatetStructure(final StateMachine sm) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("typedef struct State_t State_t;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("struct State_t {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void (*entry)();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void (*exit)();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("void (*doActivity)();");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genDataTypeStructDeclarations(final PrimitiveType primitiveType) {
    StringConcatenation _builder = new StringConcatenation();
    {
      EList<Comment> _ownedComments = primitiveType.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _hasStereotype = GenUtils.hasStereotype(primitiveType, Typedef.class);
      if (_hasStereotype) {
        _builder.append("typedef ");
        String _definition = UMLUtil.<Typedef>getStereotypeApplication(primitiveType, Typedef.class).getDefinition();
        _builder.append(_definition);
        _builder.append(" ");
        CharSequence _genName = CommonScript.genName(primitiveType);
        _builder.append(_genName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("typedef struct ");
        CharSequence _genName_1 = CommonScript.genName(primitiveType);
        _builder.append(_genName_1);
        _builder.append(" ");
        CharSequence _genName_2 = CommonScript.genName(primitiveType);
        _builder.append(_genName_2);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("struct ");
        CharSequence _genName_3 = CommonScript.genName(primitiveType);
        _builder.append(_genName_3);
        _builder.append("{");
        _builder.newLineIfNotEmpty();
        {
          EList<Property> _ownedAttributes = primitiveType.getOwnedAttributes();
          for(final Property attribute : _ownedAttributes) {
            {
              boolean _isStatic = attribute.isStatic();
              boolean _not = (!_isStatic);
              if (_not) {
                _builder.append("\t");
                CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
                _builder.append(_genVariableDeclaration, "\t");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("};");
        _builder.newLine();
      }
    }
    return _builder;
  }
}
