/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;

public class RealizationUtils {
    public static final String REALIZATION_OF = "realization of ";

    public static void addRealization(Class implementation, Interface intf) {
        if (!RealizationUtils.hasRealization(implementation, intf)) {
            InterfaceRealization ir = implementation.createInterfaceRealization(RealizationUtils.calcRealizationName(intf), intf);
            ir.getClients().add((Object)implementation);
            ir.getSuppliers().add((Object)intf);
        }
    }

    public static boolean hasRealization(Class implementation, Interface intf) {
        return implementation.getInterfaceRealization(null, intf) != null;
    }

    public static String calcRealizationName(Interface intf) {
        String name = intf.getName();
        if (name == null) {
            name = "undefined";
        }
        return REALIZATION_OF + name;
    }

    public static void addUsage(Class portType, Interface usedInterface) {
        if (!portType.getUsedInterfaces().contains((Object)usedInterface)) {
            portType.createUsage((NamedElement)usedInterface);
        }
    }
}

