/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StUtils {
    public static void copyStereotypes(Element source, Element destination) {
        for (Stereotype stereotype : source.getAppliedStereotypes()) {
            StUtils.copyAttributes(stereotype.getQualifiedName(), source, destination);
        }
    }

    public static boolean copyAttributes(String stereotypeName, Element source, Element destination) {
        Stereotype stereoSource = source.getAppliedStereotype(stereotypeName);
        Stereotype stereoDest = destination.getApplicableStereotype(stereotypeName);
        if (stereoSource == null || stereoDest == null) {
            return false;
        }
        Stereotype alreadyApplied = destination.getAppliedStereotype(stereotypeName);
        if (alreadyApplied == null) {
            destination.applyStereotype(stereoDest);
        }
        for (Property attribute : stereoSource.getAllAttributes()) {
            String attrName = attribute.getName();
            if (attrName.length() >= 5 && attrName.startsWith("base_") || attribute.isDerived()) continue;
            Object value = source.getValue(stereoSource, attrName);
            if (value instanceof EList) {
                BasicEList newList = new BasicEList();
                for (Object valueEl : (EList)value) {
                    newList.add(valueEl);
                }
                if (newList.size() <= 0) continue;
                destination.setValue(stereoDest, attrName, (Object)newList);
                continue;
            }
            destination.setValue(stereoDest, attrName, value);
        }
        return true;
    }
}

