/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.sync;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.OperationUtils;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class InterfaceSync {
    public static final String SIG_PREFIX = "SIG_";
    private static final String SIGNAL_RECEPTION_QN = "sysinterfaces::SignalReception";
    protected static boolean useGenericSigInterface = false;

    public static void syncSignalReceptionSupport(Interface intf) {
        if (useGenericSigInterface) {
            InterfaceSync.syncGenericSignalReceptionSupport(intf);
        } else {
            InterfaceSync.syncSpecificSignalReceptionSupport(intf);
        }
    }

    public static void syncSpecificSignalReceptionSupport(Interface intf) {
        for (Reception reception : intf.getOwnedReceptions()) {
            Signal signal = reception.getSignal();
            if (signal == null) continue;
            String opName = SIG_PREFIX + signal.getName();
            Operation existingOperation = intf.getOwnedOperation(opName, null, null);
            Operation newOperation = UMLFactory.eINSTANCE.createOperation();
            newOperation.setName(opName);
            for (Property attribute : signal.getAttributes()) {
                Parameter parameter = newOperation.createOwnedParameter(attribute.getName(), attribute.getType());
                parameter.setLower(attribute.getLower());
                parameter.setUpper(attribute.getUpper());
            }
            if (existingOperation == null) {
                intf.getOwnedOperations().add((Object)newOperation);
            } else if (!OperationUtils.isSameOperation((Operation)existingOperation, (Operation)newOperation)) {
                OperationUtils.syncOperation((Operation)newOperation, (Operation)existingOperation);
            }
            DerivedElement de = (DerivedElement)StereotypeUtil.applyApp((Element)newOperation, DerivedElement.class);
            if (de == null) continue;
            de.setSource((Element)reception);
        }
        BasicEList ownedOperations = new BasicEList();
        ownedOperations.addAll((Collection)intf.getOwnedOperations());
        for (Operation operation : ownedOperations) {
            DerivedElement de = (DerivedElement)UMLUtil.getStereotypeApplication((Element)operation, DerivedElement.class);
            if (de == null) continue;
            if (de.getSource() instanceof Reception) {
                Reception reception = (Reception)de.getSource();
                Signal signal = reception.getSignal();
                if (signal != null && (SIG_PREFIX + signal.getName()).equals(operation.getName())) continue;
                operation.destroy();
                continue;
            }
            operation.destroy();
        }
    }

    public static void syncGenericSignalReceptionSupport(Interface intf) {
        NamedElement genericReceptionNE = ElementUtils.getQualifiedElementFromRS((Element)intf, (String)SIGNAL_RECEPTION_QN);
        if (genericReceptionNE instanceof Interface) {
            Interface genericReceptionIntf = (Interface)genericReceptionNE;
            if (intf.getOwnedReceptions().size() > 0) {
                if (!InterfaceSync.hasReceptionSupport(intf, genericReceptionIntf)) {
                    InterfaceSync.addReceptionSupport(intf, genericReceptionIntf);
                }
            } else if (InterfaceSync.hasReceptionSupport(intf, genericReceptionIntf)) {
                InterfaceSync.removeReceptionSupport(intf, genericReceptionIntf);
            }
        }
    }

    public static boolean hasReceptionSupport(Interface intf, Interface genericReceptionIntf) {
        for (Classifier general : intf.getGenerals()) {
            if (general != genericReceptionIntf) continue;
            return true;
        }
        return false;
    }

    public static void addReceptionSupport(Interface intf, Interface genericReceptionIntf) {
        intf.createGeneralization((Classifier)genericReceptionIntf);
    }

    public static void removeReceptionSupport(Interface intf, Interface genericReceptionIntf) {
        for (Generalization generalization : intf.getGeneralizations()) {
            if (generalization.getGeneral() != genericReceptionIntf) continue;
            generalization.destroy();
        }
    }
}

