/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.templates;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.copylisteners.PostCopyListener;
import org.eclipse.papyrus.designer.transformation.core.templates.InstantiationContext;
import org.eclipse.papyrus.designer.transformation.core.templates.PostTemplateInstantiationListener;
import org.eclipse.papyrus.designer.transformation.core.templates.PreTemplateInstantiationListener;
import org.eclipse.papyrus.designer.transformation.core.templates.TemplateUtils;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterContainment;
import org.eclipse.papyrus.designer.transformation.core.transformations.filters.FilterSignatures;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;

public class TemplateInstantiation {
    protected static Map<Package, LazyCopier> copierSet;
    protected static Map<EObject, Boolean> appliedPost;
    Package packageTemplate;
    public TemplateBinding binding;
    protected LazyCopier copier;
    protected TemplateSignature signature;
    protected Resource sourceResource;
    protected Resource targetResource;
    protected Map<EObject, EObject> templateMap;
    protected Map<EObject, Map<EObject, EObject>> templateMapInfo;
    public static InstantiationContext context;

    public static void init() {
        copierSet = new WeakHashMap<Package, LazyCopier>();
    }

    public TemplateInstantiation(TemplateBinding binding) throws TransformationException {
        if (binding == null) {
            throw new TransformationException("Passed binding is null");
        }
        this.signature = binding.getSignature();
        if (this.signature == null) {
            throw new TransformationException("Passed template binding does not have a signature");
        }
        this.packageTemplate = (Package)this.signature.getOwner();
        Package boundPackage = (Package)binding.getBoundElement();
        context = new InstantiationContext(this);
        this.binding = binding;
        this.copier = copierSet.get(boundPackage);
        if (this.copier == null) {
            this.copier = new LazyCopier(this.packageTemplate, boundPackage, LazyCopier.CopyExtResources.ALL, true);
            copierSet.put(boundPackage, this.copier);
            this.copier.preCopyListeners.add((Object)FilterContainment.getInstance());
            FilterContainment.getInstance().setRoot((EObject)boundPackage);
            this.copier.preCopyListeners.add((Object)FilterSignatures.getInstance());
            this.copier.preCopyListeners.add((Object)PreTemplateInstantiationListener.getInstance());
            PreTemplateInstantiationListener.getInstance().init();
        }
        if (boundPackage.getPackagedElements().size() > 0 && this.copier.keySet().size() == 0) {
            this.sourceResource = this.packageTemplate.eResource();
            this.targetResource = boundPackage.eResource();
            this.syncCopyMap((EObject)this.packageTemplate, (EObject)boundPackage);
        }
        for (TemplateParameterSubstitution substitution : binding.getParameterSubstitutions()) {
            ParameterableElement formal = substitution.getFormal().getParameteredElement();
            ParameterableElement actual = substitution.getActual();
            this.copier.putPair((EObject)formal, (EObject)actual);
        }
        appliedPost = new HashMap<EObject, Boolean>();
    }

    public void syncCopyMap(EObject source, EObject targetPkg) {
        if (this.copier.get(source) == null || this.copier.getStatus(targetPkg) != LazyCopier.CopyStatus.FULL) {
            this.copier.put(source, targetPkg);
            if (source instanceof Package) {
                this.copier.setStatus(targetPkg, LazyCopier.CopyStatus.SHALLOW);
            } else {
                this.copier.setStatus(targetPkg, LazyCopier.CopyStatus.FULL);
            }
            for (EObject targetSubElem : targetPkg.eContents()) {
                NamedElement sourceSubElement = null;
                if (targetSubElem instanceof NamedElement) {
                    String targetName = ((NamedElement)targetSubElem).getName();
                    sourceSubElement = ElementUtils.getNamedElementFromList((EList)source.eContents(), (String)targetName);
                }
                if (sourceSubElement == null) {
                    String uriFragment = this.targetResource.getURIFragment(targetSubElem);
                    sourceSubElement = this.sourceResource.getEObject(uriFragment);
                }
                if (sourceSubElement == null) continue;
                this.syncCopyMap((EObject)sourceSubElement, targetSubElem);
            }
        }
    }

    public <T extends Element> T bindElement(T namedElement) throws TransformationException {
        if (namedElement == null) {
            throw new TransformationException(Messages.TemplateInstantiation_TemplateIsNull);
        }
        EList<Namespace> path = TemplateUtils.relativePathWithMerge(namedElement, (Namespace)this.packageTemplate);
        if (path != null) {
            Element owner = TemplateUtils.getTemplateOwner(namedElement, this.signature);
            if (owner != null) {
                Package boundPackage = (Package)this.binding.getBoundElement();
                this.copier.put(owner, boundPackage);
            }
        } else {
            TemplateSignature signatureOfNE;
            if (namedElement instanceof TemplateableElement && (signatureOfNE = TemplateUtils.getSignature((TemplateableElement)namedElement)) != null && this.signature != signatureOfNE) {
                TemplateBinding subBinding = TemplateUtils.getSubBinding(this.copier.target, (TemplateableElement)namedElement, this.binding);
                TemplateInstantiation ti = new TemplateInstantiation(subBinding);
                T ret = ti.bindElement(namedElement);
                return ret;
            }
            return this.copier.getCopy(namedElement);
        }
        NamedElement existingMember = (NamedElement)this.copier.get(namedElement);
        if (existingMember == null) {
            T copiedElement = this.copier.getCopy(namedElement);
            this.applyPost((EObject)this.copier.target, Collections.singletonList(PostTemplateInstantiationListener.getInstance()));
            return copiedElement;
        }
        return (T)existingMember;
    }

    protected void applyPost(EObject element, List<PostCopyListener> listeners) {
        if (!appliedPost.containsKey(element)) {
            appliedPost.put(element, true);
            for (PostCopyListener listener : listeners) {
                listener.postCopyEObject(this.copier, element);
            }
            for (EObject subElement : element.eContents()) {
                this.applyPost(subElement, listeners);
            }
        }
    }
}

