/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.transformations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformation;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafoChain;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExecuteChainUtil {
    public static void apply(M2MTrafoChain chain, List<M2MTrafo> additionalTrafos) throws TransformationException {
        ArrayList<M2MTrafo> transformations = new ArrayList<M2MTrafo>();
        for (Property m2mTrafoRef : chain.getBase_Class().getAllAttributes()) {
            M2MTrafo trafo = (M2MTrafo)UMLUtil.getStereotypeApplication((Element)m2mTrafoRef.getType(), M2MTrafo.class);
            if (trafo != null) {
                transformations.add(trafo);
                continue;
            }
            throw new TransformationException(String.format(Messages.ExecuteChainUtil_M2M_TRAFO_NOT_APPLIED, m2mTrafoRef.getName()));
        }
        for (M2MTrafo additionalTrafo : additionalTrafos) {
            if (additionalTrafo.getBefore() != null) {
                int index = transformations.indexOf(additionalTrafo.getBefore());
                if (index < 0) continue;
                transformations.add(index, additionalTrafo);
                continue;
            }
            if (additionalTrafo.getAfter() != null) {
                int index = transformations.indexOf(additionalTrafo.getAfter());
                if (index < 0) continue;
                transformations.add(index + 1, additionalTrafo);
                continue;
            }
            transformations.add(additionalTrafo);
        }
        ExecuteTransformation.apply(transformations.iterator());
    }
}

