/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ChangeEventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;

    public ChangeEventTransformation(SM2ClassesTransformationCore core) {
        this.core = core;
        this.superContext = core.superContext;
        this.cdefs = core.cdefs;
    }

    public void createChangeEvents() {
        boolean _isEmpty = this.core.changeEvents.isEmpty();
        if (_isEmpty) {
            return;
        }
        String WAIT_TIME = "10";
        Operation changeEventOp = this.superContext.createOwnedOperation("listenChangeEvent", null, null);
        changeEventOp.createOwnedParameter("id", this.core.intType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("struct timeval tv;");
        _builder.newLine();
        _builder.append("struct timespec ts;");
        _builder.newLine();
        _builder.append("bool oldValue;");
        _builder.newLine();
        _builder.append("bool newValue;");
        _builder.newLine();
        _builder.append("bool isFirstTime = true;");
        _builder.newLine();
        _builder.append("bool periodic = ");
        _builder.append(WAIT_TIME);
        _builder.append("; //ms");
        _builder.newLineIfNotEmpty();
        _builder.append("while(true) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("switch(id) {");
        _builder.newLine();
        for (ChangeEvent ch : this.core.changeEvents) {
            _builder.append("\t\t");
            _builder.append("case ");
            String _eventID = TransformationUtil.eventID((Event)ch);
            _builder.append(_eventID, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("newValue = ");
            String _changeEventExpression = this.getChangeEventExpression(ch);
            _builder.append(_changeEventExpression, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("break;");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (isFirstTime) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("oldValue = newValue;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("isFirstTime = false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#ifdef WIN32");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Sleep(periodic);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#elif _POSIX_C_SOURCE >= 199309L");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("struct timespec ts;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("ts.tv_sec = periodic / 1000;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("ts.tv_nsec = (periodic % 1000) * 1000000;");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("nanosleep(&ts, NULL);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#else");
        _builder.newLine();
        _builder.append("\t\t    ");
        _builder.append("usleep(periodic * 1000);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (oldValue != newValue) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("//the expression is changed, push an event to the queue");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("eventQueue", "\t\t");
        _builder.append(".push(statemachine::PRIORITY_2, NULL, id, statemachine::CHANGE_EVENT, 0);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("oldValue = newValue;");
        _builder.newLine();
        _builder.append("}");
        this.core.createOpaqueBehavior(this.superContext, changeEventOp, _builder.toString());
    }

    public String getChangeEventExpression(ChangeEvent e) {
        if (e.getChangeExpression() == null || !(e.getChangeExpression() instanceof OpaqueExpression)) {
            return "false";
        }
        ValueSpecification _changeExpression = e.getChangeExpression();
        return (String)IterableExtensions.head((Iterable)((OpaqueExpression)_changeExpression).getBodies());
    }
}

