/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.core.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.designer.ucm.core.Messages;
import org.eclipse.papyrus.designer.ucm.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.designer.ucm.core.menu.MenuHelper;
import org.eclipse.papyrus.designer.ucm.core.provider.PortElementKindContentProvider;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.PortElement;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.PortElementKind;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.PortType;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_technicalpolicies.TechnicalPolicyDefinition;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortElementEditHelperAdvice
extends AbstractEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateElementRequest) {
            return this.approveCreateElementRequest((CreateElementRequest)context.getEditCommandRequest());
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateElementRequest(CreateElementRequest request) {
        IElementType type = request.getElementType();
        EObject container = request.getContainer();
        if (type != null && container instanceof Class) {
            if (UMLUtil.getStereotypeApplication((Element)((Class)container), PortType.class) != null) {
                return true;
            }
            if (UMLUtil.getStereotypeApplication((Element)((Class)container), TechnicalPolicyDefinition.class) != null) {
                return true;
            }
        }
        return false;
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        Object result;
        final EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Element)) {
            return super.getAfterConfigureCommand(request);
        }
        PortElementKindContentProvider cp = new PortElementKindContentProvider();
        EnhancedPopupMenu popupMenu = MenuHelper.createPopupMenu(cp, Messages.PortElementEditHelperAdvice_ChooseValue, false);
        CompositeCommand compositeCommand = new CompositeCommand(Messages.PortElementEditHelperAdvice_1);
        if (popupMenu.show((Control)Display.getCurrent().getActiveShell()) && (result = popupMenu.getSubResult()) instanceof PortElementKind) {
            final PortElementKind kind = (PortElementKind)result;
            RecordingCommand setPortElemKind = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

                protected void doExecute() {
                    PortElement portElement = (PortElement)StereotypeUtil.applyApp((Element)((Element)newElement), PortElement.class);
                    portElement.setKind(kind);
                }
            };
            compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)setPortElemKind));
        }
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }
}

