/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.FCM;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InterceptionKind implements Enumerator
{
    INTERCEPT_SOME(0, "InterceptSome", "InterceptSome"),
    INTERCEPT_ALL(1, "InterceptAll", "InterceptAll"),
    INTERCEPT_ALL_OUT(2, "InterceptAllOut", "InterceptAllOut"),
    INTERCEPT_ALL_IN(3, "InterceptAllIn", "InterceptAllIn"),
    INTERCEPT_MATCHING(4, "InterceptMatching", "InterceptMatching");

    public static final int INTERCEPT_SOME_VALUE = 0;
    public static final int INTERCEPT_ALL_VALUE = 1;
    public static final int INTERCEPT_ALL_OUT_VALUE = 2;
    public static final int INTERCEPT_ALL_IN_VALUE = 3;
    public static final int INTERCEPT_MATCHING_VALUE = 4;
    private static final InterceptionKind[] VALUES_ARRAY;
    public static final List<InterceptionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InterceptionKind[]{INTERCEPT_SOME, INTERCEPT_ALL, INTERCEPT_ALL_OUT, INTERCEPT_ALL_IN, INTERCEPT_MATCHING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InterceptionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterceptionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterceptionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InterceptionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InterceptionKind get(int value) {
        switch (value) {
            case 0: {
                return INTERCEPT_SOME;
            }
            case 1: {
                return INTERCEPT_ALL;
            }
            case 2: {
                return INTERCEPT_ALL_OUT;
            }
            case 3: {
                return INTERCEPT_ALL_IN;
            }
            case 4: {
                return INTERCEPT_MATCHING;
            }
        }
        return null;
    }

    private InterceptionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

