/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.transformations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.deployment.tools.Activator;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.HintUtils;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.transformation.base.UIContext;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class GenerateCode
implements IM2MTrafoCDP {
    public void generate(InstanceSpecification node, String targetLanguage) throws TransformationException, InterruptedException {
        IProgressMonitor monitor = UIContext.monitor;
        IProject genProject = TransformationContext.current.project;
        Package genModel = TransformationContext.current.mm.getModel();
        monitor.worked(1);
        if (genProject == null) {
            throw new TransformationException(Messages.GenerateCode_NoProject);
        }
        if (node == null) {
            monitor.setTaskName(String.format(Messages.GenerateCode_GeneratingCode, targetLanguage));
        } else {
            monitor.setTaskName(String.format(Messages.GenerateCode_GeneratingCodeForNode, targetLanguage, node.getName()));
        }
        ILangCodegen codegen = LanguageCodegen.getGenerator((String)targetLanguage);
        codegen.generateCode(genProject, (PackageableElement)genModel, monitor);
        for (ModelManagement mm : TransformationContext.current.copier.getAdditionalRootPkgs()) {
            codegen.generateCode(genProject, (PackageableElement)mm.getModel(), monitor);
        }
        codegen.cleanCode(genProject, (PackageableElement)genModel, TransformationContext.current.keepFiles, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
    }

    public PackageableElement getNearestClassifierOrPackage(Element element) {
        while (element != null) {
            if (element instanceof Classifier) {
                return (Classifier)element;
            }
            if (element instanceof Package) {
                return (Package)element;
            }
            element = element.getOwner();
        }
        return null;
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        EList topLevelInstances = DepUtils.getTopLevelInstances((Package)deploymentPlan);
        String targetLanguage = topLevelInstances.size() > 0 ? DepUtils.getTargetLanguage((InstanceSpecification)((InstanceSpecification)topLevelInstances.iterator().next())) : HintUtils.getLanguageFromElement((Element)deploymentPlan);
        try {
            this.generate(null, targetLanguage);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

