/**
 * Copyright (c) 2015-2019 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Ansgar Radermacher  ansgar.radermacher@cea.fr
 *  Shuai Li (CEA LIST) <shuai.li@cea.fr> - Bug 530651
 *  Shuai Li (CEA LIST) <shuai.li@cea.fr> - Bug 531771
 *  Yoann Farre (CIL4Sys) <yoann.farre@cil4sys.com> - Bug 543072, Bug 559033
 */
package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.modellibs.core.transformations.AbstractCompToOO;
import org.eclipse.papyrus.designer.components.modellibs.core.transformations.Constants;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.cpp.Activator;
import org.eclipse.papyrus.designer.components.transformation.cpp.Messages;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ConstInit;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Friend;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Inline;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Variadic;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Virtual;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * This class realizes the transformation from component-based to object-oriented
 * models for C++. It refines the abstract component to OO transformation
 */
@SuppressWarnings("all")
public class StaticCppToOO extends AbstractCompToOO implements IOOTrafo {
  @Override
  public void init(final LazyCopier copier, final org.eclipse.uml2.uml.Class bootloader) {
    super.init(copier, bootloader);
    this.progLang = "C/C++";
  }

  @Override
  public String nameRef(final Property attribute) {
    return CppUtils.nameRef(attribute);
  }

  /**
   * Apply a pointer to the (typed) element
   */
  @Override
  public void applyRef(final Element element) {
    StereotypeUtil.apply(element, Ptr.class);
  }

  /**
   * Create a ptr_type for the given typed element
   * This is required, in order to create a vector of pointers
   * instead of a pointer towards a vector
   */
  public Type createPtrType(final Type type) {
    boolean _endsWith = type.getName().endsWith("_ptr");
    boolean _not = (!_endsWith);
    if (_not) {
      final org.eclipse.uml2.uml.Package pkg = type.getNearestPackage();
      String _name = type.getName();
      final String name = (_name + "_ptr");
      PackageableElement _packagedElement = pkg.getPackagedElement(name);
      PrimitiveType ptrType = ((PrimitiveType) _packagedElement);
      if ((ptrType == null)) {
        ptrType = pkg.createOwnedPrimitiveType(name);
        final Typedef typedef = StereotypeUtil.<Typedef>applyApp(ptrType, Typedef.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("class ");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        _builder.append(" *");
        typedef.setDefinition(_builder.toString());
      }
      return ptrType;
    } else {
      return type;
    }
  }

  @Override
  public String getRef(final Property attribute) {
    return CppUtils.getRef(attribute);
  }

  /**
   * Transform parts if necessary.
   * 
   * If the bootloader is responsible for creating an instance (if it is a
   * abstract type), mark the associated part as a C++ pointer. We do not want
   * to change the aggregation kind, since it remains logically a composition,
   * it is merely an implementation issue that it must be a pointer for C++ if
   * the concrete type is not yet known.
   * 
   * @param compositeImplementation
   *            a (composite) component
   */
  @Override
  public void transformParts(final org.eclipse.uml2.uml.Class compositeImplementation) {
    EList<Property> _parts = PartsUtil.getParts(compositeImplementation);
    for (final Property attribute : _parts) {
      {
        final Type type = attribute.getType();
        if ((type instanceof org.eclipse.uml2.uml.Class)) {
          boolean _instantiateViaBootloader = AbstractCompToOO.instantiateViaBootloader(((org.eclipse.uml2.uml.Class)type));
          if (_instantiateViaBootloader) {
            StereotypeUtil.apply(attribute, Ptr.class);
          }
        }
      }
    }
  }

  @Override
  public boolean addGetPortOperationImpl(final org.eclipse.uml2.uml.Class implementation, final PortInfo portInfo, final Interface providedIntf, final String portName) {
    boolean _xblockexpression = false;
    {
      final String opName = (PrefixConstants.getP_Prefix + portName);
      Operation op = implementation.getOwnedOperation(opName, null, null);
      final Parameter retParam = op.getOwnedParameters().get(0);
      retParam.setName(Constants.retParamName);
      this.applyRef(retParam);
      Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, 
        UMLPackage.eINSTANCE.getOpaqueBehavior());
      final OpaqueBehavior behavior = ((OpaqueBehavior) _createOwnedBehavior);
      op.getMethods().add(behavior);
      final List<ConnectorEnd> ces = ConnectorUtil.getDelegations(implementation, portInfo.getModelPort());
      int connectedDelegations = 0;
      for (final ConnectorEnd ce : ces) {
        {
          final ConnectableElement role = ce.getRole();
          if ((role instanceof Port)) {
            final Port rolePort = ((Port) role);
            boolean _contains = rolePort.getProvideds().contains(providedIntf);
            if (_contains) {
              connectedDelegations++;
            }
          } else {
            if ((role instanceof Property)) {
              final Type roleType = ((Property) role).getType();
              if (((roleType instanceof BehavioredClassifier) && 
                (((BehavioredClassifier) roleType).getInterfaceRealization(null, providedIntf) != null))) {
                connectedDelegations++;
              }
            }
          }
        }
      }
      final boolean isMultipleDelegations = (connectedDelegations > 1);
      String body = null;
      if (isMultipleDelegations) {
        final CreateMultiRefClass dc = new CreateMultiRefClass(this, this.copier);
        body = dc.createDelegationProvided(implementation, ces, portInfo.getPort(), portName, providedIntf);
      } else {
        boolean _isEmpty = ces.isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          body = "return ";
          int i = 0;
          while (((i < ces.size()) && body.equals("return "))) {
            {
              final Property part = ces.get(i).getPartWithPort();
              final ConnectableElement role = ces.get(i).getRole();
              if ((role instanceof Port)) {
                final Port rolePort = ((Port) role);
                boolean _contains = rolePort.getProvideds().contains(providedIntf);
                if (_contains) {
                  if (((rolePort.getProvideds().size() > 1) || (!(rolePort.getType() instanceof Interface)))) {
                    String _body = body;
                    StringConcatenation _builder = new StringConcatenation();
                    String _nameRef = this.nameRef(part);
                    _builder.append(_nameRef);
                    _builder.append(PrefixConstants.getP_Prefix);
                    String _name = ((Port)role).getName();
                    _builder.append(_name);
                    String _name_1 = providedIntf.getName();
                    _builder.append(_name_1);
                    _builder.append("();");
                    body = (_body + _builder);
                  } else {
                    String _body_1 = body;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _nameRef_1 = this.nameRef(part);
                    _builder_1.append(_nameRef_1);
                    _builder_1.append(PrefixConstants.getP_Prefix);
                    String _name_2 = ((Port)role).getName();
                    _builder_1.append(_name_2);
                    _builder_1.append("();");
                    body = (_body_1 + _builder_1);
                  }
                }
              } else {
                if ((role instanceof Property)) {
                  final Type roleType = ((Property) role).getType();
                  if (((roleType instanceof BehavioredClassifier) && 
                    (((BehavioredClassifier) roleType).getInterfaceRealization(null, providedIntf) != null))) {
                    String _body_2 = body;
                    String _name_3 = ((Property)role).getName();
                    body = (_body_2 + _name_3);
                  }
                }
              }
              i++;
            }
          }
          boolean _equals = body.equals("return ");
          if (_equals) {
            String _body = body;
            body = (_body + "NULL;");
          }
        } else {
          InterfaceRealization _interfaceRealization = implementation.getInterfaceRealization(null, providedIntf);
          boolean implementsIntf = (_interfaceRealization != null);
          if ((!implementsIntf)) {
            final Interface providedIntfInCopy = this.copier.<Interface>getCopy(providedIntf);
            InterfaceRealization _interfaceRealization_1 = implementation.getInterfaceRealization(null, providedIntfInCopy);
            boolean _tripleNotEquals = (_interfaceRealization_1 != null);
            implementsIntf = _tripleNotEquals;
          }
          if (implementsIntf) {
            body = "return this;";
          } else {
            Activator.log.debug(
              String.format(Messages.CompImplTrafos_IntfNotImplemented, providedIntf.getName(), 
                portInfo.getPort().getName(), implementation.getName()));
            body = "return NULL; // see error message in log during code generation";
          }
        }
      }
      behavior.getLanguages().add(this.progLang);
      _xblockexpression = behavior.getBodies().add(body);
    }
    return _xblockexpression;
  }

  @Override
  public Boolean addConnectPortOperation(final org.eclipse.uml2.uml.Class implementation, final PortInfo portInfo, final Interface requiredIntf, final String portName) {
    Boolean _xblockexpression = null;
    {
      final String opName = (PrefixConstants.connectQ_Prefix + portName);
      Boolean _xifexpression = null;
      Operation _ownedOperation = implementation.getOwnedOperation(opName, null, null);
      boolean _tripleNotEquals = (_ownedOperation != null);
      if (_tripleNotEquals) {
        _xifexpression = null;
      } else {
        Boolean _xblockexpression_1 = null;
        {
          Operation op = implementation.createOwnedOperation(opName, null, null);
          final Parameter refParam = op.createOwnedParameter("ref", requiredIntf);
          final Comment comment = refParam.createOwnedComment();
          comment.setBody("Reference to provided port");
          this.applyRef(refParam);
          Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, 
            UMLPackage.eINSTANCE.getOpaqueBehavior());
          final OpaqueBehavior behavior = ((OpaqueBehavior) _createOwnedBehavior);
          op.getMethods().add(behavior);
          final List<ConnectorEnd> ces = ConnectorUtil.getDelegations(implementation, portInfo.getModelPort());
          String body = "";
          boolean _isEmpty = ces.isEmpty();
          boolean _not = (!_isEmpty);
          if (_not) {
            int i = 0;
            while ((i < ces.size())) {
              {
                final Property part = ces.get(i).getPartWithPort();
                final ConnectableElement role = ces.get(i).getRole();
                String bodyConstruction = "";
                if ((role instanceof Port)) {
                  final Port rolePort = ((Port) role);
                  boolean _contains = rolePort.getRequireds().contains(requiredIntf);
                  if (_contains) {
                    String _name = ((Port)role).getName();
                    String targetOpName = (PrefixConstants.connectQ_Prefix + _name);
                    if (((rolePort.getRequireds().size() > 1) || (!(rolePort.getType() instanceof Interface)))) {
                      String _targetOpName = targetOpName;
                      String _name_1 = requiredIntf.getName();
                      targetOpName = (_targetOpName + _name_1);
                    }
                    int _upper = part.getUpper();
                    boolean _greaterThan = (_upper > 1);
                    if (_greaterThan) {
                      for (int j = 0; (j < part.getUpper()); j++) {
                        String _bodyConstruction = bodyConstruction;
                        StringConcatenation _builder = new StringConcatenation();
                        String _name_2 = part.getName();
                        _builder.append(_name_2);
                        _builder.append("[");
                        _builder.append(i);
                        _builder.append("].");
                        _builder.append(targetOpName);
                        _builder.append("(ref);");
                        bodyConstruction = (_bodyConstruction + _builder);
                      }
                    } else {
                      String _bodyConstruction = bodyConstruction;
                      StringConcatenation _builder = new StringConcatenation();
                      String _nameRef = this.nameRef(part);
                      _builder.append(_nameRef);
                      _builder.append(targetOpName);
                      _builder.append("(ref);");
                      bodyConstruction = (_bodyConstruction + _builder);
                    }
                  }
                } else {
                  if (((part.getType() instanceof Classifier) && 
                    ((Classifier) part.getType()).getAllUsedInterfaces().contains(requiredIntf))) {
                    int _upper_1 = part.getUpper();
                    boolean _greaterThan_1 = (_upper_1 > 1);
                    if (_greaterThan_1) {
                      for (int j = 0; (j < part.getUpper()); j++) {
                        String _bodyConstruction_1 = bodyConstruction;
                        StringConcatenation _builder_1 = new StringConcatenation();
                        String _name_2 = part.getName();
                        _builder_1.append(_name_2);
                        _builder_1.append("[");
                        _builder_1.append(i);
                        _builder_1.append("];");
                        bodyConstruction = (_bodyConstruction_1 + _builder_1);
                      }
                    } else {
                      String _bodyConstruction_1 = bodyConstruction;
                      StringConcatenation _builder_1 = new StringConcatenation();
                      String _name_2 = part.getName();
                      _builder_1.append(_name_2);
                      _builder_1.append(";");
                      bodyConstruction = (_bodyConstruction_1 + _builder_1);
                    }
                  }
                }
                boolean _isEmpty_1 = bodyConstruction.isEmpty();
                boolean _not_1 = (!_isEmpty_1);
                if (_not_1) {
                  String _body = body;
                  body = (_body + bodyConstruction);
                  int _size = ces.size();
                  int _minus = (_size - 1);
                  boolean _lessThan = (i < _minus);
                  if (_lessThan) {
                    String _body_1 = body;
                    body = (_body_1 + AbstractCompToOO.NL);
                  }
                }
                i++;
              }
            }
          } else {
            final String attributeName = (PrefixConstants.attributePrefix + portName);
            final Port port = portInfo.getPort();
            int _upper = port.getUpper();
            boolean _notEquals = (_upper != 1);
            if (_notEquals) {
              final CreateMultiRefClass dc = new CreateMultiRefClass(this, this.copier);
              String _body = body;
              String _createDelegationRequired = dc.createDelegationRequired(implementation, portName, requiredIntf);
              body = (_body + _createDelegationRequired);
            } else {
              Property attr = implementation.getOwnedAttribute(attributeName, null);
              if (((attr == null) || (attr instanceof Port))) {
                attr = implementation.createOwnedAttribute(attributeName, requiredIntf);
                CopyUtils.copyMultElemModifiers(portInfo.getPort(), attr);
                attr.setAggregation(AggregationKind.SHARED_LITERAL);
              }
              String _body_1 = body;
              StringConcatenation _builder = new StringConcatenation();
              _builder.append(attributeName);
              _builder.append(" = ref;");
              body = (_body_1 + _builder);
            }
          }
          behavior.getLanguages().add(this.progLang);
          behavior.getBodies().add(body);
          Boolean _xifexpression_1 = null;
          if (((PrefixConstants.getConnQ_Prefix.length() > 0) && (!ces.isEmpty()))) {
            boolean _xblockexpression_2 = false;
            {
              final String getConnOpName = (PrefixConstants.getConnQ_Prefix + portName);
              Operation getConnOp = implementation.getOwnedOperation(getConnOpName, null, null);
              if ((getConnOp == null)) {
                getConnOp = implementation.createOwnedOperation(getConnOpName, null, null, requiredIntf);
                final Parameter retParam = op.getOwnedParameters().get(0);
                retParam.setName(Constants.retParamName);
                this.applyRef(retParam);
              }
              Behavior _createOwnedBehavior_1 = implementation.createOwnedBehavior(getConnOpName, 
                UMLPackage.eINSTANCE.getOpaqueBehavior());
              final OpaqueBehavior getConnBehavior = ((OpaqueBehavior) _createOwnedBehavior_1);
              getConnOp.getMethods().add(getConnBehavior);
              final String name = (PrefixConstants.attributePrefix + portName);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("return ");
              _builder_1.append(name);
              _builder_1.append(";");
              body = _builder_1.toString();
              behavior.getLanguages().add(this.progLang);
              _xblockexpression_2 = behavior.getBodies().add(body.trim());
            }
            _xifexpression_1 = Boolean.valueOf(_xblockexpression_2);
          } else {
            _xifexpression_1 = null;
          }
          _xblockexpression_1 = _xifexpression_1;
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }

  @Override
  public String connectPorts(final Connector connector, final ConnectorEnd receptacleEnd, final ConnectorEnd facetEnd, final Port subPort) throws TransformationException {
    final Association association = connector.getType();
    if (((receptacleEnd.getRole() instanceof Port) && (facetEnd.getRole() instanceof Port))) {
      ConnectableElement _role = facetEnd.getRole();
      final Port facetPort = ((Port) _role);
      ConnectableElement _role_1 = receptacleEnd.getRole();
      final Port receptaclePort = ((Port) _role_1);
      final PortInfo facetPI = PortInfo.fromSubPort(facetPort, subPort);
      final PortInfo receptaclePI = PortInfo.fromSubPort(receptaclePort, subPort);
      if (((facetPI.getProvided() != null) && (receptaclePI.getRequired() != null))) {
        final Property facetPart = facetEnd.getPartWithPort();
        final Property receptaclePart = receptacleEnd.getPartWithPort();
        String subPortName = "";
        if ((subPort != null)) {
          String _subPortName = subPortName;
          String _name = subPort.getName();
          String _plus = ("_" + _name);
          subPortName = (_subPortName + _plus);
        }
        String result = "";
        if (((receptaclePI.getRequireds().size() == 1) && (receptaclePI.getPort().getType() instanceof Interface))) {
          String facetPortName = "";
          if (((facetPI.getProvideds().size() == 1) && (facetPI.getPort().getType() instanceof Interface))) {
            facetPortName = facetPI.getName();
          } else {
            if (((facetPI.getProvideds().size() >= 1) && 
              facetPI.getProvideds().contains(receptaclePI.getRequired()))) {
              String _facetPortName = facetPortName;
              String _name_1 = facetPI.getName();
              String _name_2 = receptaclePI.getRequired().getName();
              String _plus_1 = (_name_1 + _name_2);
              facetPortName = (_facetPortName + _plus_1);
            }
          }
          boolean _isEmpty = facetPortName.isEmpty();
          boolean _not = (!_isEmpty);
          if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            String _nameRef = this.nameRef(receptaclePart);
            _builder.append(_nameRef);
            _builder.append("connect_");
            String _name_3 = receptaclePort.getName();
            _builder.append(_name_3);
            _builder.append(subPortName);
            final String setter = _builder.toString();
            int _upper = facetPart.getUpper();
            boolean _greaterThan = (_upper > 1);
            if (_greaterThan) {
              for (int i = 0; (i < facetPart.getUpper()); i++) {
                {
                  StringConcatenation _builder_1 = new StringConcatenation();
                  String _name_4 = facetPart.getName();
                  _builder_1.append(_name_4);
                  _builder_1.append("[");
                  _builder_1.append(i);
                  _builder_1.append("].get_");
                  _builder_1.append(facetPortName);
                  _builder_1.append(subPortName);
                  _builder_1.append("()");
                  final String getter = _builder_1.toString();
                  String _result = result;
                  StringConcatenation _builder_2 = new StringConcatenation();
                  _builder_2.append(setter);
                  _builder_2.append("(");
                  _builder_2.append(getter);
                  _builder_2.append(");");
                  String _plus_2 = (_builder_2.toString() + AbstractCompToOO.NL);
                  result = (_result + _plus_2);
                }
              }
            } else {
              StringConcatenation _builder_1 = new StringConcatenation();
              String _nameRef_1 = this.nameRef(facetPart);
              _builder_1.append(_nameRef_1);
              _builder_1.append("get_");
              _builder_1.append(facetPortName);
              _builder_1.append(subPortName);
              _builder_1.append("()");
              final String getter = _builder_1.toString();
              String _result = result;
              StringConcatenation _builder_2 = new StringConcatenation();
              _builder_2.append(setter);
              _builder_2.append("(");
              _builder_2.append(getter);
              _builder_2.append(");");
              String _plus_2 = (_builder_2.toString() + AbstractCompToOO.NL);
              result = (_result + _plus_2);
            }
          }
        } else {
          List<Interface> _requireds = receptaclePI.getRequireds();
          for (final Interface requiredInterface : _requireds) {
            {
              String _name_4 = receptaclePI.getName();
              String _name_5 = requiredInterface.getName();
              String receptaclePortName = (_name_4 + _name_5);
              String facetPortName_1 = "";
              boolean _contains = facetPI.getProvideds().contains(requiredInterface);
              if (_contains) {
                String _facetPortName_1 = facetPortName_1;
                String _name_6 = facetPI.getName();
                facetPortName_1 = (_facetPortName_1 + _name_6);
                if (((facetPI.getProvideds().size() > 1) || (!(facetPI.getPort().getType() instanceof Interface)))) {
                  String _facetPortName_2 = facetPortName_1;
                  String _name_7 = requiredInterface.getName();
                  facetPortName_1 = (_facetPortName_2 + _name_7);
                }
              }
              boolean _isEmpty_1 = facetPortName_1.isEmpty();
              boolean _not_1 = (!_isEmpty_1);
              if (_not_1) {
                StringConcatenation _builder_3 = new StringConcatenation();
                String _nameRef_2 = this.nameRef(receptaclePart);
                _builder_3.append(_nameRef_2);
                _builder_3.append("connect_");
                _builder_3.append(receptaclePortName);
                _builder_3.append(subPortName);
                final String setter_1 = _builder_3.toString();
                int _upper_1 = facetPart.getUpper();
                boolean _greaterThan_1 = (_upper_1 > 1);
                if (_greaterThan_1) {
                  for (int i = 0; (i < facetPart.getUpper()); i++) {
                    {
                      StringConcatenation _builder_4 = new StringConcatenation();
                      String _name_8 = facetPart.getName();
                      _builder_4.append(_name_8);
                      _builder_4.append("[");
                      _builder_4.append(i);
                      _builder_4.append("].get_");
                      _builder_4.append(facetPortName_1);
                      _builder_4.append(subPortName);
                      _builder_4.append("()");
                      final String getter_1 = _builder_4.toString();
                      String _result_1 = result;
                      StringConcatenation _builder_5 = new StringConcatenation();
                      _builder_5.append(setter_1);
                      _builder_5.append("(");
                      _builder_5.append(getter_1);
                      _builder_5.append(");");
                      String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
                      result = (_result_1 + _plus_3);
                    }
                  }
                } else {
                  StringConcatenation _builder_4 = new StringConcatenation();
                  String _nameRef_3 = this.nameRef(facetPart);
                  _builder_4.append(_nameRef_3);
                  _builder_4.append("get_");
                  _builder_4.append(facetPortName_1);
                  _builder_4.append(subPortName);
                  _builder_4.append("()");
                  final String getter_1 = _builder_4.toString();
                  String _result_1 = result;
                  StringConcatenation _builder_5 = new StringConcatenation();
                  _builder_5.append(setter_1);
                  _builder_5.append("(");
                  _builder_5.append(getter_1);
                  _builder_5.append(");");
                  String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
                  result = (_result_1 + _plus_3);
                }
              }
            }
          }
        }
        return result;
      }
    } else {
      ConnectableElement _role_2 = receptacleEnd.getRole();
      if ((_role_2 instanceof Port)) {
        ConnectableElement _role_3 = receptacleEnd.getRole();
        final Port receptaclePort_1 = ((Port) _role_3);
        Interface _required = PortUtils.getRequired(receptaclePort_1);
        boolean _tripleNotEquals = (_required != null);
        if (_tripleNotEquals) {
          ConnectableElement _role_4 = facetEnd.getRole();
          final Property facetPart_1 = ((Property) _role_4);
          final Property receptaclePart_1 = facetEnd.getPartWithPort();
          String result_1 = "";
          int _size = receptaclePort_1.getRequireds().size();
          boolean _greaterThan_1 = (_size > 1);
          if (_greaterThan_1) {
            EList<Interface> _requireds_1 = receptaclePort_1.getRequireds();
            for (final Interface requiredInterface_1 : _requireds_1) {
              {
                String _name_4 = receptaclePort_1.getName();
                String _name_5 = requiredInterface_1.getName();
                String receptaclePortName = (_name_4 + _name_5);
                StringConcatenation _builder_3 = new StringConcatenation();
                String _nameRef_2 = this.nameRef(receptaclePart_1);
                _builder_3.append(_nameRef_2);
                _builder_3.append("connect_");
                _builder_3.append(receptaclePortName);
                final String setter_1 = _builder_3.toString();
                int _upper_1 = facetPart_1.getUpper();
                boolean _greaterThan_2 = (_upper_1 > 1);
                if (_greaterThan_2) {
                  for (int i = 0; (i < facetPart_1.getUpper()); i++) {
                    {
                      StringConcatenation _builder_4 = new StringConcatenation();
                      String _name_6 = facetPart_1.getName();
                      _builder_4.append(_name_6);
                      _builder_4.append("[");
                      _builder_4.append(i);
                      _builder_4.append("]");
                      final String getter_1 = _builder_4.toString();
                      String _result_1 = result_1;
                      StringConcatenation _builder_5 = new StringConcatenation();
                      _builder_5.append(setter_1);
                      _builder_5.append("(");
                      _builder_5.append(getter_1);
                      _builder_5.append(");");
                      String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
                      result_1 = (_result_1 + _plus_3);
                    }
                  }
                } else {
                  StringConcatenation _builder_4 = new StringConcatenation();
                  String _ref = this.getRef(facetPart_1);
                  _builder_4.append(_ref);
                  final String getter_1 = _builder_4.toString();
                  String _result_1 = result_1;
                  StringConcatenation _builder_5 = new StringConcatenation();
                  _builder_5.append(setter_1);
                  _builder_5.append("(");
                  _builder_5.append(getter_1);
                  _builder_5.append(");");
                  String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
                  result_1 = (_result_1 + _plus_3);
                }
              }
            }
          } else {
            StringConcatenation _builder_3 = new StringConcatenation();
            String _nameRef_2 = this.nameRef(receptaclePart_1);
            _builder_3.append(_nameRef_2);
            _builder_3.append("connect_");
            String _name_4 = receptaclePort_1.getName();
            _builder_3.append(_name_4);
            final String setter_1 = _builder_3.toString();
            int _upper_1 = facetPart_1.getUpper();
            boolean _greaterThan_2 = (_upper_1 > 1);
            if (_greaterThan_2) {
              for (int i = 0; (i < facetPart_1.getUpper()); i++) {
                {
                  StringConcatenation _builder_4 = new StringConcatenation();
                  String _name_5 = facetPart_1.getName();
                  _builder_4.append(_name_5);
                  _builder_4.append("[");
                  _builder_4.append(i);
                  _builder_4.append("]");
                  final String getter_1 = _builder_4.toString();
                  String _result_1 = result_1;
                  StringConcatenation _builder_5 = new StringConcatenation();
                  _builder_5.append(setter_1);
                  _builder_5.append("(");
                  _builder_5.append(getter_1);
                  _builder_5.append(");");
                  String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
                  result_1 = (_result_1 + _plus_3);
                }
              }
            } else {
              StringConcatenation _builder_4 = new StringConcatenation();
              String _ref = this.getRef(facetPart_1);
              _builder_4.append(_ref);
              final String getter_1 = _builder_4.toString();
              String _result_1 = result_1;
              StringConcatenation _builder_5 = new StringConcatenation();
              _builder_5.append(setter_1);
              _builder_5.append("(");
              _builder_5.append(getter_1);
              _builder_5.append(");");
              String _plus_3 = (_builder_5.toString() + AbstractCompToOO.NL);
              result_1 = (_result_1 + _plus_3);
            }
          }
          return result_1;
        }
      } else {
        ConnectableElement _role_5 = facetEnd.getRole();
        if ((_role_5 instanceof Port)) {
          ConnectableElement _role_6 = facetEnd.getRole();
          final Port facetPort_1 = ((Port) _role_6);
          Interface _provided = PortUtils.getProvided(facetPort_1);
          boolean _tripleNotEquals_1 = (_provided != null);
          if (_tripleNotEquals_1) {
            final Property facetPart_2 = facetEnd.getPartWithPort();
            ConnectableElement _role_7 = facetEnd.getRole();
            final Property receptaclePart_2 = ((Property) _role_7);
            String result_2 = "";
            int _size_1 = facetPort_1.getProvideds().size();
            boolean _greaterThan_3 = (_size_1 > 1);
            if (_greaterThan_3) {
              EList<Interface> _provideds = facetPort_1.getProvideds();
              for (final Interface providedInterface : _provideds) {
                {
                  String _name_5 = facetPort_1.getName();
                  String _name_6 = providedInterface.getName();
                  String facetPortName_1 = (_name_5 + _name_6);
                  final String setter_2 = receptaclePart_2.getName();
                  int _upper_2 = facetPart_2.getUpper();
                  boolean _greaterThan_4 = (_upper_2 > 1);
                  if (_greaterThan_4) {
                    for (int i = 0; (i < facetPart_2.getUpper()); i++) {
                      {
                        StringConcatenation _builder_6 = new StringConcatenation();
                        String _name_7 = facetPart_2.getName();
                        _builder_6.append(_name_7);
                        _builder_6.append("[");
                        _builder_6.append(i);
                        _builder_6.append("].get_");
                        _builder_6.append(facetPortName_1);
                        _builder_6.append("();");
                        final String getter_2 = _builder_6.toString();
                        String _result_2 = result_2;
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append(setter_2);
                        _builder_7.append(" = ");
                        _builder_7.append(getter_2);
                        _builder_7.append(";");
                        String _plus_4 = (_builder_7.toString() + AbstractCompToOO.NL);
                        result_2 = (_result_2 + _plus_4);
                      }
                    }
                  } else {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    String _nameRef_3 = this.nameRef(facetPart_2);
                    _builder_6.append(_nameRef_3);
                    _builder_6.append("get_");
                    _builder_6.append(facetPortName_1);
                    _builder_6.append("();");
                    final String getter_2 = _builder_6.toString();
                    String _result_2 = result_2;
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append(setter_2);
                    _builder_7.append(" = ");
                    _builder_7.append(getter_2);
                    _builder_7.append(";");
                    String _plus_4 = (_builder_7.toString() + AbstractCompToOO.NL);
                    result_2 = (_result_2 + _plus_4);
                  }
                }
              }
            } else {
              final String setter_2 = receptaclePart_2.getName();
              int _upper_2 = facetPart_2.getUpper();
              boolean _greaterThan_4 = (_upper_2 > 1);
              if (_greaterThan_4) {
                for (int i = 0; (i < facetPart_2.getUpper()); i++) {
                  {
                    StringConcatenation _builder_6 = new StringConcatenation();
                    String _name_5 = facetPart_2.getName();
                    _builder_6.append(_name_5);
                    _builder_6.append("[");
                    _builder_6.append(i);
                    _builder_6.append("].get_");
                    String _name_6 = facetPort_1.getName();
                    _builder_6.append(_name_6);
                    _builder_6.append("();");
                    final String getter_2 = _builder_6.toString();
                    String _result_2 = result_2;
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append(setter_2);
                    _builder_7.append(" = ");
                    _builder_7.append(getter_2);
                    _builder_7.append(";");
                    String _plus_4 = (_builder_7.toString() + AbstractCompToOO.NL);
                    result_2 = (_result_2 + _plus_4);
                  }
                }
              } else {
                StringConcatenation _builder_6 = new StringConcatenation();
                String _nameRef_3 = this.nameRef(facetPart_2);
                _builder_6.append(_nameRef_3);
                _builder_6.append("get_");
                String _name_5 = facetPort_1.getName();
                _builder_6.append(_name_5);
                _builder_6.append("();");
                final String getter_2 = _builder_6.toString();
                String _result_2 = result_2;
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append(setter_2);
                _builder_7.append(" = ");
                _builder_7.append(getter_2);
                _builder_7.append(";");
                String _plus_4 = (_builder_7.toString() + AbstractCompToOO.NL);
                result_2 = (_result_2 + _plus_4);
              }
            }
            return result_2;
          }
        } else {
          if ((association != null)) {
            ConnectableElement _role_8 = facetEnd.getRole();
            final Property facetPart_3 = ((Property) _role_8);
            ConnectableElement _role_9 = receptacleEnd.getRole();
            final Property receptaclePart_3 = ((Property) _role_9);
            final Property assocProp1 = association.getMemberEnd(null, facetPart_3.getType());
            if (((assocProp1 != null) && assocProp1.isNavigable())) {
              StringConcatenation _builder_8 = new StringConcatenation();
              String _name_6 = receptaclePart_3.getName();
              _builder_8.append(_name_6);
              _builder_8.append(".");
              String _name_7 = assocProp1.getName();
              _builder_8.append(_name_7);
              String setter_3 = _builder_8.toString();
              StringConcatenation _builder_9 = new StringConcatenation();
              String _name_8 = facetPart_3.getName();
              _builder_9.append(_name_8);
              final String getter_3 = _builder_9.toString();
              StringConcatenation _builder_10 = new StringConcatenation();
              _builder_10.append(setter_3);
              _builder_10.append(" = ");
              _builder_10.append(getter_3);
              _builder_10.append(";");
              return (_builder_10.toString() + AbstractCompToOO.NL);
            }
          } else {
            String _name_9 = connector.getName();
            String _plus_5 = ("Connector <" + _name_9);
            String _plus_6 = (_plus_5 + 
              "> does not use ports, but it is not typed (only connectors between ports should not be typed)");
            throw new TransformationException(_plus_6);
          }
        }
      }
    }
    return "";
  }

  public void copyCppOperationAndParameterStereotypes(final Element source, final Element target) {
    if ((((source instanceof Operation) && (target instanceof Operation)) || ((source instanceof Parameter) && (target instanceof Parameter)))) {
      Array _stereotypeApplication = UMLUtil.<Array>getStereotypeApplication(source, Array.class);
      boolean _tripleNotEquals = (_stereotypeApplication != null);
      if (_tripleNotEquals) {
        StereotypeUtil.apply(target, Array.class);
      }
      Const _stereotypeApplication_1 = UMLUtil.<Const>getStereotypeApplication(source, Const.class);
      boolean _tripleNotEquals_1 = (_stereotypeApplication_1 != null);
      if (_tripleNotEquals_1) {
        StereotypeUtil.apply(target, Const.class);
      }
      Ptr _stereotypeApplication_2 = UMLUtil.<Ptr>getStereotypeApplication(source, Ptr.class);
      boolean _tripleNotEquals_2 = (_stereotypeApplication_2 != null);
      if (_tripleNotEquals_2) {
        final Ptr sourceStereotype = UMLUtil.<Ptr>getStereotypeApplication(source, Ptr.class);
        StereotypeUtil.apply(target, Ptr.class);
        Ptr stereotype = UMLUtil.<Ptr>getStereotypeApplication(target, Ptr.class);
        if ((stereotype != null)) {
          String _declaration = sourceStereotype.getDeclaration();
          boolean _tripleNotEquals_3 = (_declaration != null);
          if (_tripleNotEquals_3) {
            String _declaration_1 = sourceStereotype.getDeclaration();
            String _string = new String(_declaration_1);
            stereotype.setDeclaration(_string);
          }
        }
      }
      Ref _stereotypeApplication_3 = UMLUtil.<Ref>getStereotypeApplication(source, Ref.class);
      boolean _tripleNotEquals_4 = (_stereotypeApplication_3 != null);
      if (_tripleNotEquals_4) {
        final Ref sourceStereotype_1 = UMLUtil.<Ref>getStereotypeApplication(source, Ref.class);
        StereotypeUtil.apply(target, Ref.class);
        Ref stereotype_1 = UMLUtil.<Ref>getStereotypeApplication(target, Ref.class);
        if ((stereotype_1 != null)) {
          String _declaration_2 = sourceStereotype_1.getDeclaration();
          boolean _tripleNotEquals_5 = (_declaration_2 != null);
          if (_tripleNotEquals_5) {
            String _declaration_3 = sourceStereotype_1.getDeclaration();
            String _string_1 = new String(_declaration_3);
            stereotype_1.setDeclaration(_string_1);
          }
        }
      }
      NoCodeGen _stereotypeApplication_4 = UMLUtil.<NoCodeGen>getStereotypeApplication(source, NoCodeGen.class);
      boolean _tripleNotEquals_6 = (_stereotypeApplication_4 != null);
      if (_tripleNotEquals_6) {
        StereotypeUtil.apply(target, NoCodeGen.class);
      }
      Volatile _stereotypeApplication_5 = UMLUtil.<Volatile>getStereotypeApplication(source, Volatile.class);
      boolean _tripleNotEquals_7 = (_stereotypeApplication_5 != null);
      if (_tripleNotEquals_7) {
        StereotypeUtil.apply(target, Volatile.class);
      }
      ConstInit _stereotypeApplication_6 = UMLUtil.<ConstInit>getStereotypeApplication(source, ConstInit.class);
      boolean _tripleNotEquals_8 = (_stereotypeApplication_6 != null);
      if (_tripleNotEquals_8) {
        final ConstInit sourceStereotype_2 = UMLUtil.<ConstInit>getStereotypeApplication(source, ConstInit.class);
        StereotypeUtil.apply(target, Array.class);
        ConstInit stereotype_2 = UMLUtil.<ConstInit>getStereotypeApplication(target, ConstInit.class);
        if ((stereotype_2 != null)) {
          String _initialisation = sourceStereotype_2.getInitialisation();
          boolean _tripleNotEquals_9 = (_initialisation != null);
          if (_tripleNotEquals_9) {
            String _initialisation_1 = sourceStereotype_2.getInitialisation();
            String _string_2 = new String(_initialisation_1);
            stereotype_2.setInitialisation(_string_2);
          }
        }
      }
      Friend _stereotypeApplication_7 = UMLUtil.<Friend>getStereotypeApplication(source, Friend.class);
      boolean _tripleNotEquals_10 = (_stereotypeApplication_7 != null);
      if (_tripleNotEquals_10) {
        StereotypeUtil.apply(target, Friend.class);
      }
      Inline _stereotypeApplication_8 = UMLUtil.<Inline>getStereotypeApplication(source, Inline.class);
      boolean _tripleNotEquals_11 = (_stereotypeApplication_8 != null);
      if (_tripleNotEquals_11) {
        StereotypeUtil.apply(target, Inline.class);
      }
      Virtual _stereotypeApplication_9 = UMLUtil.<Virtual>getStereotypeApplication(source, Virtual.class);
      boolean _tripleNotEquals_12 = (_stereotypeApplication_9 != null);
      if (_tripleNotEquals_12) {
        StereotypeUtil.apply(target, Virtual.class);
      }
      Variadic _stereotypeApplication_10 = UMLUtil.<Variadic>getStereotypeApplication(source, Variadic.class);
      boolean _tripleNotEquals_13 = (_stereotypeApplication_10 != null);
      if (_tripleNotEquals_13) {
        StereotypeUtil.apply(target, Variadic.class);
      }
      if (((source instanceof Operation) && (target instanceof Operation))) {
        int _size = ((Operation) source).getOwnedParameters().size();
        int _size_1 = ((Operation) target).getOwnedParameters().size();
        boolean _equals = (_size == _size_1);
        if (_equals) {
          int i = 0;
          while ((i < ((Operation) source).getOwnedParameters().size())) {
            {
              this.copyCppOperationAndParameterStereotypes(((Operation) source).getOwnedParameters().get(i), 
                ((Operation) target).getOwnedParameters().get(i));
              i++;
            }
          }
        }
      }
    }
  }
}
