/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.designer.languages.common.base.file.ICleanUntouched;
import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.common.base.file.IOUtilsTmp;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.base.file.ProtSection;

public class ProjectBasedFileAccess
implements IPFileSystemAccess,
ICleanUntouched,
IFileExists {
    IProject project;
    String subFolderName;
    protected Map<String, Boolean> touched;
    static final boolean force = true;

    public ProjectBasedFileAccess(IProject project) {
        this(project, null);
    }

    public ProjectBasedFileAccess(IProject project, String subFolderName) {
        this.setProject(project, subFolderName);
        this.touched = new HashMap<String, Boolean>();
    }

    public void setProject(IProject project) {
        this.setProject(project, null);
    }

    public void setProject(IProject project, String subFolderName) {
        this.project = project;
        this.subFolderName = subFolderName;
    }

    @Override
    public void generateFile(String fileName, String content) {
        IFile file = this.getFile(fileName);
        this.touched.put(file.getFullPath().toString(), true);
        try {
            boolean needsRefresh = false;
            if (file.exists()) {
                content = ProtSection.mergeProtectedSections(file.getLocation(), content);
                ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
                if (!IOUtilsTmp.contentEquals(file.getContents(), contentStream)) {
                    ((InputStream)contentStream).reset();
                    file.setContents((InputStream)contentStream, true, true, null);
                    needsRefresh = true;
                }
            } else {
                ByteArrayInputStream contentStream = new ByteArrayInputStream(content.getBytes());
                file.create((InputStream)contentStream, true, null);
                needsRefresh = true;
            }
            if (needsRefresh) {
                file.refreshLocal(2, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void deleteFile(String fileName) {
        IFile file = this.getFile(fileName);
        try {
            if (file.exists()) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IFile getFile(String filename) {
        String[] paths = filename.split("/");
        try {
            IContainer packageContainer = this.getFolder((IContainer)this.project, this.subFolderName);
            int i = 0;
            while (i < paths.length - 1) {
                String path = paths[i];
                packageContainer = this.getFolder(packageContainer, path);
                this.touched.put(packageContainer.getFullPath().toString(), true);
                ++i;
            }
            String last = paths[paths.length - 1];
            return this.getFile(packageContainer, last);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected IContainer getFolder(IContainer container, String folderName) throws CoreException {
        if (folderName == null) {
            return container;
        }
        IFolder folder = null;
        if (container instanceof IFolder) {
            folder = ((IFolder)container).getFolder(folderName);
        } else if (container instanceof IProject) {
            folder = ((IProject)container).getFolder(folderName);
        }
        if (folder != null && !folder.exists()) {
            folder.create(false, true, null);
        }
        return folder;
    }

    public IFile getFile(IContainer container, String fileName) {
        if (container instanceof IFolder) {
            return ((IFolder)container).getFile(fileName);
        }
        if (container instanceof IProject) {
            return ((IProject)container).getFile(fileName);
        }
        return null;
    }

    @Override
    public void cleanUntouched(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.cleanUntouched((IFolder)resource, monitor);
                }
                if (!this.touched.containsKey(resource.getFullPath().toString())) {
                    resource.delete(false, monitor);
                }
                ++n2;
            }
        }
    }

    @Override
    public void cleanUntouched(IFolder folder, List<String> keepFiles, IProgressMonitor monitor) throws CoreException {
        for (String fileName : keepFiles) {
            this.touched.put(fileName, true);
        }
        this.cleanUntouched(folder, monitor);
    }

    @Override
    public boolean existsFile(String fileName) {
        IFile file = this.getFile(fileName);
        return file != null && file.exists();
    }
}

