/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GridLineCellLayerPainter
extends CellLayerPainter {
    private final Color gridColor;
    protected boolean renderGridLines = true;
    protected Integer gridLineWidth = 1;

    public GridLineCellLayerPainter(Color gridColor) {
        this.gridColor = gridColor;
    }

    public GridLineCellLayerPainter() {
        this.gridColor = GUIHelper.COLOR_GRAY;
    }

    public GridLineCellLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(clipLeft, clipTop);
        this.gridColor = gridColor;
    }

    public GridLineCellLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        Boolean renderConfig = null;
        LabelStack stack = natLayer.getRegionLabelsByXY(xOffset, yOffset);
        ArrayList<String> labels = new ArrayList();
        if (stack != null) {
            labels = stack.getLabels();
            renderConfig = configRegistry.getConfigAttribute(CellConfigAttributes.RENDER_GRID_LINES, "NORMAL", labels);
        }
        boolean bl = this.renderGridLines = renderConfig != null ? renderConfig : true;
        if (this.renderGridLines) {
            Integer width = configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_WIDTH, "NORMAL", labels);
            this.gridLineWidth = width != null ? width : 1;
            int oldLineWidth = gc.getLineWidth();
            gc.setLineWidth(this.gridLineWidth.intValue());
            this.drawGridLines(natLayer, gc, rectangle, configRegistry, labels);
            gc.setLineWidth(oldLineWidth);
        }
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
    }

    @Override
    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle bounds) {
        Integer adjustment = this.renderGridLines ? this.gridLineWidth : 0;
        int startAdjustment = adjustment == 1 ? 0 : Math.round(adjustment.floatValue() / 2.0f);
        int sizeAdjustment = adjustment == 1 ? 1 : Math.round(adjustment.floatValue() / 2.0f);
        return new Rectangle(bounds.x - startAdjustment, bounds.y - startAdjustment, Math.max(bounds.width - sizeAdjustment, 0), Math.max(bounds.height - sizeAdjustment, 0));
    }

    @Deprecated
    protected void drawGridLines(ILayer natLayer, GC gc, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.drawGridLines(natLayer, gc, rectangle, configRegistry, new ArrayList<String>());
    }

    protected void drawGridLines(ILayer natLayer, GC gc, Rectangle rectangle, IConfigRegistry configRegistry, List<String> labels) {
        Color gColor = configRegistry.getConfigAttribute(CellConfigAttributes.GRID_LINE_COLOR, "NORMAL", labels);
        gc.setForeground(gColor != null ? gColor : this.gridColor);
        int adjustment = this.gridLineWidth == 1 ? 1 : Math.round(this.gridLineWidth.floatValue() / 2.0f);
        this.drawHorizontalLines(natLayer, gc, rectangle, adjustment);
        this.drawVerticalLines(natLayer, gc, rectangle, adjustment);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle, int adjustment) {
        int endX = rectangle.x + Math.min(natLayer.getWidth() - adjustment, rectangle.width);
        if (endX > natLayer.getWidth()) {
            return;
        }
        int rowPositionByY = natLayer.getRowPositionByY(rectangle.y + rectangle.height);
        int maxRowPosition = rowPositionByY > 0 ? Math.min(natLayer.getRowCount(), rowPositionByY) : natLayer.getRowCount();
        int rowPosition = natLayer.getRowPositionByY(rectangle.y);
        while (rowPosition < maxRowPosition) {
            int size = natLayer.getRowHeightByPosition(rowPosition);
            if (size > 0) {
                int y = natLayer.getStartYOfRowPosition(rowPosition) + size - adjustment;
                gc.drawLine(rectangle.x, y, endX, y);
            }
            ++rowPosition;
        }
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle, int adjustment) {
        int endY = rectangle.y + Math.min(natLayer.getHeight() - adjustment, rectangle.height);
        if (endY > natLayer.getHeight()) {
            return;
        }
        int columnPositionByX = natLayer.getColumnPositionByX(rectangle.x + rectangle.width);
        int maxColumnPosition = columnPositionByX > 0 ? Math.min(natLayer.getColumnCount(), columnPositionByX) : natLayer.getColumnCount();
        int columnPosition = natLayer.getColumnPositionByX(rectangle.x);
        while (columnPosition < maxColumnPosition) {
            int size = natLayer.getColumnWidthByPosition(columnPosition);
            if (size > 0) {
                int x = natLayer.getStartXOfColumnPosition(columnPosition) + size - adjustment;
                gc.drawLine(x, rectangle.y, x, endY);
            }
            ++columnPosition;
        }
    }
}

