/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.transition.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.uml.textedit.transition.xtext.ui.internal.UmlTransitionActivator;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.BehaviorKind;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.CallOrSignalEventRule;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.ChangeEventRule;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.EventRule;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.RelativeTimeEventRule;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.TimeEventRule;
import org.eclipse.papyrus.uml.textedit.transition.xtext.umlTransition.TransitionRule;
import org.eclipse.papyrus.uml.tools.helper.EventCreationHelper;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransitionEditorConfigurationContribution
extends DefaultXtextDirectEditorConfiguration
implements ICustomDirectEditorConfiguration {
    private static final String EMPTY = "";
    public static final String LANGUAGE = "Advanced transition textual editor";

    public int getStyle() {
        return 66;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Transition) {
            Transition transition = (Transition)editedObject;
            String textToEdit = EMPTY;
            if (!transition.getTriggers().isEmpty()) {
                boolean isFirstTrigger = true;
                for (Trigger t : transition.getTriggers()) {
                    if (!isFirstTrigger) {
                        textToEdit = String.valueOf(textToEdit) + ", ";
                    } else {
                        isFirstTrigger = false;
                    }
                    Event e = t.getEvent();
                    if (e instanceof CallEvent) {
                        textToEdit = String.valueOf(textToEdit) + ((CallEvent)e).getOperation().getName();
                        continue;
                    }
                    if (e instanceof SignalEvent) {
                        textToEdit = String.valueOf(textToEdit) + ((SignalEvent)e).getSignal().getName();
                        continue;
                    }
                    if (e instanceof ChangeEvent) {
                        ValueSpecification specification = ((ChangeEvent)e).getChangeExpression();
                        if (!(specification instanceof OpaqueExpression)) continue;
                        String body = this.retrieveBody((OpaqueExpression)specification, "Natural language");
                        textToEdit = String.valueOf(textToEdit) + "when \"" + body + "\"";
                        continue;
                    }
                    if (e instanceof TimeEvent) {
                        String absRelPrefix = ((TimeEvent)e).isRelative() ? "after " : "at ";
                        textToEdit = String.valueOf(textToEdit) + absRelPrefix + "\"" + this.retrieveBody((OpaqueExpression)((TimeEvent)e).getWhen().getExpr(), "Natural language") + "\"";
                        continue;
                    }
                    textToEdit = String.valueOf(textToEdit) + "all";
                }
            }
            if (transition.getGuard() != null && transition.getGuard().getSpecification() != null) {
                textToEdit = String.valueOf(textToEdit) + " [" + "\"" + this.retrieveBody((OpaqueExpression)transition.getGuard().getSpecification(), "Natural language") + "\"" + "]";
            }
            if (transition.getEffect() != null) {
                textToEdit = String.valueOf(textToEdit) + " /\n";
                String behaviorKind = EMPTY;
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals(EMPTY) && transition.getEffect() instanceof Activity ? "Activity " : EMPTY);
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals(EMPTY) && transition.getEffect() instanceof StateMachine ? "StateMachine " : EMPTY);
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals(EMPTY) && transition.getEffect() instanceof OpaqueBehavior ? "OpaqueBehavior " : EMPTY);
                textToEdit = String.valueOf(textToEdit) + behaviorKind + " " + transition.getEffect().getName();
            }
            return textToEdit;
        }
        return "not a State";
    }

    private String retrieveBody(OpaqueExpression exp, String languageName) {
        String body = EMPTY;
        if (exp == null) {
            return body;
        }
        int index = 0;
        for (String _languageName : exp.getLanguages()) {
            if (_languageName.equals(languageName)) {
                if (index < exp.getBodies().size()) {
                    return (String)exp.getBodies().get(index);
                }
                return EMPTY;
            }
            ++index;
        }
        return body;
    }

    public Injector getInjector() {
        return UmlTransitionActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.transition.xtext.UmlTransition");
    }

    protected ICommand getParseCommand(EObject modelObject, EObject xtextObject) {
        if (!(modelObject instanceof Transition)) {
            return null;
        }
        Transition transition = (Transition)modelObject;
        TransitionRule transitionRuleObject = (TransitionRule)xtextObject;
        try {
            TransactionalEditingDomain dom = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)transition);
            UpdateUMLTransitionCommand updateCommand = new UpdateUMLTransitionCommand(dom, transition, transitionRuleObject);
            return updateCommand;
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    protected class UpdateUMLTransitionCommand
    extends AbstractTransactionalCommand {
        private static final String ANY = "any";
        private final Transition transition;
        private final TransitionRule transitionRuleObject;
        private List<Trigger> newTriggers;
        private Constraint newConstraint;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            for (Trigger t : this.transition.getTriggers()) {
                Event e = t.getEvent();
                t.setEvent(null);
                if (UML2Util.getNonNavigableInverseReferences((EObject)e).size() != 0) continue;
                e.destroy();
            }
            this.transition.getTriggers().removeAll((Collection)this.transition.getTriggers());
            Constraint guard = this.transition.getGuard();
            this.transition.setGuard(null);
            if (guard != null) {
                guard.destroy();
            }
            if (this.transitionRuleObject != null) {
                if (this.transitionRuleObject.getTriggers() != null) {
                    for (EventRule eventRule : this.transitionRuleObject.getTriggers()) {
                        Trigger newTrigger = UMLFactory.eINSTANCE.createTrigger();
                        this.newTriggers.add(newTrigger);
                        newTrigger.setEvent(this.createUMLEvent(eventRule));
                    }
                    this.transition.getTriggers().addAll(this.newTriggers);
                }
                if (this.transitionRuleObject.getGuard() != null && this.transitionRuleObject.getGuard().getConstraint() != null) {
                    this.newConstraint = this.transition.createGuard(TransitionEditorConfigurationContribution.EMPTY);
                    OpaqueExpression guardSpecification = UMLFactory.eINSTANCE.createOpaqueExpression();
                    guardSpecification.getLanguages().add((Object)"Natural language");
                    guardSpecification.getBodies().add((Object)this.transitionRuleObject.getGuard().getConstraint());
                    this.newConstraint.setSpecification((ValueSpecification)guardSpecification);
                }
                boolean hasEffect = this.transitionRuleObject.getEffect() != null && this.transitionRuleObject.getEffect().getKind() != null && this.transitionRuleObject.getEffect().getBehaviorName() != null;
                BehaviorKind oldKind = this.getBehaviorKind(this.transition.getEffect());
                if (!hasEffect || this.transitionRuleObject.getEffect().getKind() != oldKind) {
                    Behavior effect = this.transition.getEffect();
                    this.transition.setEffect(null);
                    if (effect != null) {
                        effect.destroy();
                    }
                }
                if (hasEffect) {
                    String behaviorName = this.transitionRuleObject.getEffect().getBehaviorName();
                    if (this.transition.getEffect() == null) {
                        Behavior newEffectBehavior = this.createUMLBehavior(this.transitionRuleObject.getEffect().getKind(), behaviorName);
                        this.transition.setEffect(newEffectBehavior);
                    } else {
                        this.transition.getEffect().setName(behaviorName);
                    }
                }
            } else {
                Behavior effect = this.transition.getEffect();
                this.transition.setEffect(null);
                if (effect != null) {
                    effect.destroy();
                }
            }
            return CommandResult.newOKCommandResult((Object)this.transition);
        }

        private Event createUMLEvent(EventRule eventRule) {
            Object e = null;
            EventCreationHelper helper = new EventCreationHelper(this.transition);
            if (eventRule instanceof CallOrSignalEventRule) {
                CallOrSignalEventRule callOrSignalEventRule = (CallOrSignalEventRule)eventRule;
                if (callOrSignalEventRule.getOperationOrSignal() != null) {
                    NamedElement operationOrSignal = callOrSignalEventRule.getOperationOrSignal();
                    e = operationOrSignal instanceof Operation ? helper.getOrCreateCallEvent((Operation)operationOrSignal, true) : helper.getOrCreateSignalEvent((Signal)operationOrSignal, true);
                }
            } else if (eventRule instanceof ChangeEventRule) {
                ChangeEventRule changeEventRule = (ChangeEventRule)eventRule;
                if (changeEventRule.getExp() != null) {
                    e = helper.getOrCreateChangeEvent(changeEventRule.getExp(), true);
                }
            } else if (eventRule instanceof TimeEventRule) {
                TimeEventRule timeEventRule = (TimeEventRule)eventRule;
                if (timeEventRule.getExpr() != null) {
                    e = helper.getOrCreateTimeEvent(timeEventRule.getExpr(), timeEventRule instanceof RelativeTimeEventRule, true);
                }
            } else {
                e = UMLFactory.eINSTANCE.createAnyReceiveEvent();
                helper.getEventPackage().getPackagedElements().add(e);
                e.setName(ANY);
            }
            return e;
        }

        protected BehaviorKind getBehaviorKind(Behavior behavior) {
            if (behavior instanceof OpaqueBehavior) {
                return BehaviorKind.OPAQUE_BEHAVIOR;
            }
            if (behavior instanceof Activity) {
                return BehaviorKind.ACTIVITY;
            }
            if (behavior instanceof StateMachine) {
                return BehaviorKind.STATE_MACHINE;
            }
            return null;
        }

        protected Behavior createUMLBehavior(BehaviorKind kind, String name) {
            if (kind == null) {
                return null;
            }
            Activity behavior = null;
            switch (kind) {
                case ACTIVITY: {
                    behavior = UMLFactory.eINSTANCE.createActivity();
                    break;
                }
                case OPAQUE_BEHAVIOR: {
                    behavior = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    break;
                }
                case STATE_MACHINE: {
                    behavior = UMLFactory.eINSTANCE.createStateMachine();
                    break;
                }
            }
            behavior.setName(name);
            return behavior;
        }

        public UpdateUMLTransitionCommand(TransactionalEditingDomain domain, Transition transition, TransitionRule transitionRule) {
            super(domain, "Transition Update", UpdateUMLTransitionCommand.getWorkspaceFiles((EObject)transition));
            this.newTriggers = new ArrayList<Trigger>();
            this.newConstraint = null;
            this.transition = transition;
            this.transitionRuleObject = transitionRule;
        }
    }
}

