/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml16.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml16.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml16.service.types.util.ConnectorUtil;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UpdateNestedPathConnectorEnd
extends EditElementCommand {
    private Boolean isSource;

    @Deprecated
    public UpdateNestedPathConnectorEnd(String label, EObject elementToEdit, IEditCommandRequest request) {
        super(label, elementToEdit, request);
    }

    public UpdateNestedPathConnectorEnd(String label, EObject elementToEdit, IEditCommandRequest request, boolean isSource) {
        super(label, elementToEdit, request);
        this.isSource = isSource;
    }

    public boolean canExecute() {
        return this.getElementToEdit() instanceof View && super.canExecute();
    }

    private Class getConnectorClass(ConnectorEnd connectorEnd) {
        Connector connector;
        Element connectorOwner;
        Element connectorEndOwner = connectorEnd.getOwner();
        if (connectorEndOwner instanceof Connector && (connectorOwner = (connector = (Connector)connectorEndOwner).getOwner()) instanceof Class) {
            return (Class)connectorOwner;
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute() || this.getConnector() == null) {
            throw new ExecutionException("Can't update NesteConnectorEnd, missing View or connector.");
        }
        EList ends = this.getConnector().getEnds();
        if (ends != null && ends.size() > 1) {
            ConnectorEnd connectorEnd = null;
            View elementToEdit = (View)this.getElementToEdit();
            connectorEnd = this.getCalculatedConnectorEnd();
            if (connectorEnd != null) {
                List<Property> nestedPath = ConnectorUtil.getNestedPath(this.getConnectorClass(connectorEnd), elementToEdit);
                NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)connectorEnd, NestedConnectorEnd.class);
                if (nestedPath.isEmpty()) {
                    if (nestedConnectorEnd != null) {
                        EcoreUtil.delete((EObject)nestedConnectorEnd, (boolean)true);
                    }
                } else {
                    if (nestedConnectorEnd == null) {
                        nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.StereotypeApplicationHelper.getInstance(null).applyStereotype((Element)connectorEnd, BlocksPackage.eINSTANCE.getNestedConnectorEnd(), null);
                    }
                    if (!nestedConnectorEnd.getPropertyPath().equals(nestedPath)) {
                        nestedConnectorEnd.getPropertyPath().clear();
                        nestedConnectorEnd.getPropertyPath().addAll(nestedPath);
                    }
                }
            }
        }
        return CommandResult.newOKCommandResult((Object)this.getElementToEdit());
    }

    private Connector getConnector() {
        if (this.getRequest() instanceof CreateRelationshipRequest) {
            return (Connector)((CreateRelationshipRequest)this.getRequest()).getNewElement();
        }
        if (this.getRequest() instanceof ReorientRelationshipRequest) {
            return (Connector)((ReorientRelationshipRequest)this.getRequest()).getRelationship();
        }
        if (this.getRequest() instanceof ConfigureRequest) {
            return (Connector)((ConfigureRequest)this.getRequest()).getElementToConfigure();
        }
        return null;
    }

    private ConnectorEnd getCalculatedConnectorEnd() {
        Connector connector = this.getConnector();
        EList ends = this.getConnector().getEnds();
        if (ends != null && ends.size() > 1) {
            if (this.isSource != null) {
                if (this.isSource.booleanValue()) {
                    return new ConnectorUtils().getSourceConnectorEnd(connector);
                }
                return new ConnectorUtils().getTargetConnectorEnd(connector);
            }
            View elementToEdit = (View)this.getElementToEdit();
            ConnectorEnd connectorEndSource = (ConnectorEnd)ends.get(0);
            if (elementToEdit.getElement().equals(connectorEndSource.getRole())) {
                return connectorEndSource;
            }
            return (ConnectorEnd)ends.get(1);
        }
        return null;
    }
}

