/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2document.generators;

import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatus;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.IStructure2DocumentGenerator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.Structure2DocumentRegistry;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureGeneratorWrapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureRegistry;
import org.eclipse.papyrus.model2doc.emf.template2structure.helpers.DocumentStructureVersionHelper;

public class Template2DocumentGenerator {
    private final DocumentTemplate documentTemplate;
    protected ITemplate2StructureGenerator t2sGenerator;
    protected IStructure2DocumentGenerator s2docGenerator;
    private DocumentStructureVersionHelper versionHelper;

    public Template2DocumentGenerator(DocumentTemplate documentTemplate) {
        this.documentTemplate = documentTemplate;
        this.versionHelper = this.createDocumentStructureVersionHelper(this.documentTemplate);
        String s2docId = this.documentTemplate.getDocumentStructureGeneratorConfiguration().getDocumentGeneratorId();
        this.s2docGenerator = Structure2DocumentRegistry.INSTANCE.getGenerator(s2docId);
        this.t2sGenerator = Template2StructureRegistry.INSTANCE.getGenerator(this.documentTemplate);
    }

    protected DocumentStructureVersionHelper createDocumentStructureVersionHelper(DocumentTemplate template) {
        return new DocumentStructureVersionHelper(template);
    }

    public IGenerationStatus generate(IModel2DocLogger logger) {
        IGenerationStatus result = this.generateDocumentStructure();
        if (result.isOK()) {
            Document generatedDocument = (Document)result.getAdaptedResult(Document.class);
            Assert.isNotNull((Object)generatedDocument);
            result = this.generateDocument(generatedDocument, logger);
            if (result.isOK()) {
                GenerationStatus newResult = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.emf.template2document", "The DocumentStructure and the file have been successfully generated.");
                newResult.setResult(result.getResult());
                result = newResult;
            }
        }
        return result;
    }

    protected IGenerationStatus generateDocumentStructure() {
        Template2StructureGeneratorWrapper wrapper = new Template2StructureGeneratorWrapper(this.documentTemplate, this.versionHelper);
        return wrapper.generateDocumentStructure();
    }

    protected IGenerationStatus generateDocument(Document documentStructure, IModel2DocLogger logger) {
        IStructure2DocumentGenerator generator = Structure2DocumentRegistry.INSTANCE.getGenerator(documentStructure);
        if (generator == null) {
            return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2document", "We can't found the document generator.");
        }
        if (!generator.handles(documentStructure)) {
            return new GenerationStatus(4, "org.eclipse.papyrus.model2doc.emf.template2document", NLS.bind((String)"The generator {0} doesn't handle the document structure.", (Object)generator.getGeneratorId()));
        }
        GenerationStatus result = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.emf.template2document", "The document generation succeed.");
        Object resultGeneration = generator.generate(documentStructure, logger);
        result.setResult(resultGeneration);
        return result;
    }
}

