/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator.Template2StructureGeneratorDescription;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.generator.Template2StructureGeneratorExtensionReader;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;

public final class Template2StructureRegistry {
    private final Map<String, Template2StructureGeneratorDescription> generators = new Template2StructureGeneratorExtensionReader().readContributions();
    public static final Template2StructureRegistry INSTANCE = new Template2StructureRegistry();

    private Template2StructureRegistry() {
    }

    public final ITemplate2StructureGenerator getGenerator(String generatorId) {
        Assert.isNotNull((Object)generatorId);
        ITemplate2StructureGenerator generator = this.generators.get(generatorId).getGenerator();
        if (generator == null) {
            Activator.log.warn(NLS.bind((String)"The is no generator registered with the id {0}", (Object)generatorId));
        }
        return generator;
    }

    public ITemplate2StructureGenerator getGenerator(DocumentTemplate docTemplate) {
        Assert.isNotNull((Object)docTemplate);
        IDocumentStructureGeneratorConfiguration conf = docTemplate.getDocumentStructureGeneratorConfiguration();
        if (conf != null) {
            return this.getGenerator(conf.getStructureGeneratorId());
        }
        return null;
    }

    public List<AbstractTemplateToStructureMapper<?>> getMappers(DocumentTemplate docTemplate) {
        String structureGeneratorId = docTemplate.getDocumentStructureGeneratorConfiguration().getStructureGeneratorId();
        if (structureGeneratorId == null || structureGeneratorId.isEmpty()) {
            Activator.log.warn(NLS.bind((String)"The document structure generator id is not defined for {0}", (Object)docTemplate.toString()));
            return Collections.emptyList();
        }
        Template2StructureGeneratorDescription generatorDescription = this.generators.get(structureGeneratorId);
        if (generatorDescription == null) {
            Activator.log.warn(NLS.bind((String)"There is no generator registered with the id {0}", (Object)structureGeneratorId));
            return Collections.emptyList();
        }
        return generatorDescription.getMappers();
    }

    public List<ITemplate2StructureGenerator> getAvailableGenerators(DocumentTemplate docTemplate) {
        ArrayList<ITemplate2StructureGenerator> generators = new ArrayList<ITemplate2StructureGenerator>();
        for (Template2StructureGeneratorDescription current : this.generators.values()) {
            if (!current.getGenerator().handles(docTemplate)) continue;
            generators.add(current.getGenerator());
        }
        return generators;
    }
}

