/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.editor.ODTEditor;
import org.eclipse.papyrus.model2doc.odt.internal.util.AdaptToPageImageResizer;
import org.eclipse.papyrus.model2doc.odt.internal.util.CaptionUtils;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageCropper;
import org.eclipse.papyrus.model2doc.odt.internal.util.IImageResizer;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.StubImageCropper;
import org.eclipse.papyrus.model2doc.odt.internal.util.WriteUtil;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOService;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOServiceImpl;

public class ParagraphImageWriter {
    private static final ODTFileIOService odtFileIOService = new ODTFileIOServiceImpl();
    private ODTEditor odtEditor;
    private boolean generateCaption;
    private boolean endParagraph;
    private IImageResizer imageResizer;
    private boolean wrapImageInTextFrame;
    private TextContentAnchorType textFrameAnchor;
    private TextContentAnchorType imageAnchor;
    private IImageCropper imageCropper;

    public ParagraphImageWriter(ODTEditor odtEditor) {
        this(odtEditor, null);
    }

    public ParagraphImageWriter(ODTEditor odtEditor, IImageResizer imageResizer) {
        this(odtEditor, imageResizer, null);
    }

    public ParagraphImageWriter(ODTEditor odtEditor, IImageResizer imageResizer, IImageCropper imageCropper) {
        Assert.isNotNull((Object)odtEditor);
        this.odtEditor = odtEditor;
        this.imageResizer = imageResizer != null ? imageResizer : new AdaptToPageImageResizer();
        this.imageCropper = imageCropper != null ? imageCropper : new StubImageCropper();
        this.configure();
    }

    protected void configure() {
        this.endParagraph = true;
        this.wrapImageInTextFrame = true;
        this.generateCaption = true;
        this.textFrameAnchor = TextContentAnchorType.AS_CHARACTER;
        this.imageAnchor = TextContentAnchorType.AT_CHARACTER;
    }

    public final void setTextFrameAnchor(TextContentAnchorType textFrameAnchor) {
        this.textFrameAnchor = textFrameAnchor;
    }

    public final void setImageAnchor(TextContentAnchorType imageAnchor) {
        this.imageAnchor = imageAnchor;
    }

    public final void setGenerateCaption(boolean generateCaption) {
        this.generateCaption = generateCaption;
    }

    public final void setEndParagraph(boolean endParagraph) {
        this.endParagraph = endParagraph;
    }

    public final void setImageResizer(IImageResizer imageResizer) {
        this.imageResizer = imageResizer != null ? imageResizer : new AdaptToPageImageResizer();
    }

    public final void setWrapImageInTextFrame(boolean wrapImageInTextFrame) {
        this.wrapImageInTextFrame = wrapImageInTextFrame;
    }

    public final void setImageCropper(IImageCropper imageCropper) {
        this.imageCropper = imageCropper != null ? imageCropper : new StubImageCropper();
    }

    private XTextFrame createTextFrameForImage() {
        XTextFrame textFrame = null;
        XMultiServiceFactory xMultiServiceFactory = this.odtEditor.getXMultiServiceFactory();
        try {
            Object tmp = xMultiServiceFactory.createInstance("com.sun.star.text.TextFrame");
            textFrame = (XTextFrame)UnoRuntime.queryInterface(XTextFrame.class, (Object)tmp);
            XPropertySet framePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textFrame);
            framePropertySet.setPropertyValue("SizeType", (Object)0);
            framePropertySet.setPropertyValue("AnchorType", (Object)this.textFrameAnchor);
            framePropertySet.setPropertyValue("ZOrder", (Object)1);
            framePropertySet.setPropertyValue("TextWrap", (Object)WrapTextMode.THROUGH);
            framePropertySet.setPropertyValue("LeftBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("RightBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("TopBorderDistance", (Object)0);
            framePropertySet.setPropertyValue("BottomBorderDistance", (Object)0);
        }
        catch (com.sun.star.uno.Exception e) {
            Activator.log.error((Throwable)e);
        }
        return textFrame;
    }

    public void writeImage(XTextCursor xTextCursor, String imageFilePath, String caption) {
        if (!imageFilePath.startsWith(odtFileIOService.getODTFilePrefix())) {
            imageFilePath = String.valueOf(odtFileIOService.getODTFilePrefix()) + imageFilePath;
        }
        try {
            XMultiServiceFactory xMultiServiceFactory = this.odtEditor.getXMultiServiceFactory();
            Object graphicObject = xMultiServiceFactory.createInstance("com.sun.star.text.TextGraphicObject");
            XTextContent graphicContent = (XTextContent)UnoRuntime.queryInterface(XTextContent.class, (Object)graphicObject);
            PropertySetUtil.setProperty(graphicContent, "AnchorType", this.imageAnchor);
            XNameContainer bitmapContainer = this.odtEditor.getBitmapTable(imageFilePath);
            if (bitmapContainer != null) {
                PropertySetUtil.setProperty(graphicContent, "GraphicURL", bitmapContainer.getByName(imageFilePath));
            }
            graphicContent = this.imageResizer.resizeImage(graphicContent, imageFilePath, this.odtEditor.getXTextDocument(), this.odtEditor.getXMultiComponentFactory(), this.odtEditor.getXComponentContext());
            XTextCursor localCursor = xTextCursor;
            if (this.wrapImageInTextFrame) {
                XTextFrame textFrame = this.createTextFrameForImage();
                XPropertySet framePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)textFrame);
                XPropertySet graphicPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)graphicContent);
                Object heightValue = graphicPropSet.getPropertyValue("Height");
                Object widthValue = graphicPropSet.getPropertyValue("Width");
                framePropertySet.setPropertyValue("Height", heightValue);
                framePropertySet.setPropertyValue("Width", widthValue);
                xTextCursor.getText().insertTextContent((XTextRange)xTextCursor, (XTextContent)textFrame, false);
                localCursor = textFrame.getText().createTextCursor();
            }
            XParagraphCursor paragraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)localCursor);
            XPropertySet paraSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)paragraphCursor);
            paraSet.setPropertyValue("ParaStyleName", (Object)"Figure");
            localCursor.getText().insertTextContent((XTextRange)localCursor, graphicContent, false);
            localCursor.gotoEnd(true);
            this.imageCropper.crop(graphicContent);
            if (this.generateCaption) {
                this.addCaption(localCursor, caption);
            }
            if (this.endParagraph) {
                WriteUtil.endParagraph(xTextCursor);
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void addCaption(XTextCursor xTextCursor, String caption) {
        if (!this.generateCaption) {
            return;
        }
        CaptionUtils.writeFigureCaption(xTextCursor, caption, this.odtEditor);
    }
}

