/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.internal.gmf.Activator;

public class GMFUnsafe {
    private GMFUnsafe() {
    }

    public static void write(TransactionalEditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        GMFUnsafe.runUnprotected(domain, writeOperation);
    }

    private static void runUnprotected(TransactionalEditingDomain domain, Runnable writeOperation) throws InterruptedException, RollbackException {
        InternalTransactionalEditingDomain internalDomain = (InternalTransactionalEditingDomain)domain;
        InternalTransaction unprotected = internalDomain.startTransaction(false, Collections.singletonMap("unprotected", true));
        try {
            writeOperation.run();
        }
        finally {
            unprotected.commit();
        }
    }

    public static void write(TransactionalEditingDomain domain, Command command) throws InterruptedException, RollbackException {
        GMFUnsafe.write(domain, new CommandRunnable(command));
    }

    public static void write(TransactionalEditingDomain domain, ICommand command) throws InterruptedException, RollbackException, ExecutionException {
        try {
            GMFUnsafe.write(domain, new GMFCommandRunnable(command));
        }
        catch (WrappedException e) {
            if (e.exception() instanceof ExecutionException) {
                throw (ExecutionException)((Object)e.exception());
            }
            throw (RuntimeException)e.exception();
        }
    }

    public static Command wrap(TransactionalEditingDomain domain, Command command) {
        return new UnsafeCommandWrapper(domain, command);
    }

    private static class CommandRunnable
    implements Runnable {
        private final Command command;

        CommandRunnable(Command command) {
            this.command = command;
        }

        @Override
        public void run() {
            this.command.execute();
        }
    }

    private static class GMFCommandRunnable
    implements Runnable {
        private final ICommand command;

        GMFCommandRunnable(ICommand command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
    }

    public static abstract class UnsafeCommand
    extends AbstractCommand {
        private final TransactionalEditingDomain domain;

        protected UnsafeCommand(TransactionalEditingDomain domain) {
            this.domain = domain;
        }

        protected UnsafeCommand(TransactionalEditingDomain domain, String label, String description) {
            super(label, description);
            this.domain = domain;
        }

        protected UnsafeCommand(TransactionalEditingDomain domain, String label) {
            super(label);
            this.domain = domain;
        }

        public final void execute() {
            try {
                GMFUnsafe.runUnprotected(this.domain, new Runnable(){

                    @Override
                    public void run() {
                        this.doExecute();
                    }
                });
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        protected abstract void doExecute();

        public final void undo() {
            try {
                GMFUnsafe.runUnprotected(this.domain, new Runnable(){

                    @Override
                    public void run() {
                        this.doUndo();
                    }
                });
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        protected void doUndo() {
        }

        public final void redo() {
            try {
                GMFUnsafe.runUnprotected(this.domain, new Runnable(){

                    @Override
                    public void run() {
                        this.doRedo();
                    }
                });
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }

        protected void doRedo() {
        }

        void handleException(Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private static class UnsafeCommandWrapper
    extends UnsafeCommand {
        private final Command command;

        UnsafeCommandWrapper(TransactionalEditingDomain domain, Command command) {
            super(domain, command.getLabel(), command.getDescription());
            this.command = command;
        }

        public void dispose() {
            this.command.dispose();
        }

        public boolean canExecute() {
            return this.command.canExecute();
        }

        @Override
        protected void doExecute() {
            this.command.execute();
        }

        public boolean canUndo() {
            return this.command.canUndo();
        }

        @Override
        protected void doUndo() {
            this.command.undo();
        }

        @Override
        protected void doRedo() {
            this.command.redo();
        }

        public Collection<?> getAffectedObjects() {
            return this.command.getAffectedObjects();
        }

        public Collection<?> getResult() {
            return this.command.getResult();
        }

        public String toString() {
            return String.format("Unsafe(%s)", this.command.toString());
        }
    }
}

