/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.jface.preference;

import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.Messages;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class GradientFieldEditor
extends FieldEditor {
    private Button colorButton;
    private Button verticalStyleButton;
    private Button horizontalStyleButton;
    private Spinner transparencyValueSpinner;
    private RGB color1 = new RGB(0, 0, 0);
    private RGB color2 = new RGB(255, 255, 255);
    private int transparency = 0;
    private int style = 1;

    public GradientFieldEditor(String gradientPreferenceName, Composite parent) {
        super(gradientPreferenceName, "", parent);
    }

    protected void adjustForNumColumns(int arg0) {
    }

    public void load() {
        super.load();
        this.setButtonImage(this.color1);
        this.transparencyValueSpinner.setSelection(this.transparency);
        if (this.style == 1) {
            this.horizontalStyleButton.setSelection(true);
        } else if (this.style == 0) {
            this.verticalStyleButton.setSelection(true);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite gradientComposite = new Composite(parent, 0);
        gradientComposite.setLayout((Layout)new GridLayout(2, false));
        Label colorLabel = new Label(gradientComposite, 0);
        colorLabel.setText(Messages.GradientFieldEditor_Color);
        this.colorButton = new Button(gradientComposite, 8);
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GradientFieldEditor.this.color1 = GradientFieldEditor.this.changeColor();
            }
        });
        Label styleLabel = new Label(gradientComposite, 0);
        styleLabel.setText(Messages.GradientFieldEditor_Style);
        Composite styleComposite = new Composite(gradientComposite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        styleComposite.setLayout((Layout)gl);
        this.verticalStyleButton = new Button(styleComposite, 16);
        this.verticalStyleButton.setText(Messages.GradientFieldEditor_Vertical);
        this.horizontalStyleButton = new Button(styleComposite, 16);
        this.horizontalStyleButton.setText(Messages.GradientFieldEditor_Horizontal);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.widget).getSelection()) {
                    return;
                }
                GradientFieldEditor.this.style = GradientFieldEditor.this.verticalStyleButton.getSelection() ? 0 : 1;
            }
        };
        this.horizontalStyleButton.addSelectionListener((SelectionListener)selectionListener);
        this.verticalStyleButton.addSelectionListener((SelectionListener)selectionListener);
        Label transparencyLabel = new Label(gradientComposite, 0);
        transparencyLabel.setText(Messages.GradientFieldEditor_Transparency);
        this.transparencyValueSpinner = new Spinner(gradientComposite, 2048);
        this.transparencyValueSpinner.setMinimum(0);
        this.transparencyValueSpinner.setMaximum(100);
        this.transparencyValueSpinner.setIncrement(1);
        this.transparencyValueSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GradientFieldEditor.this.transparency = GradientFieldEditor.this.transparencyValueSpinner.getSelection();
            }
        });
    }

    protected void doLoad() {
        String preferenceValue = this.getPreferenceStore().getString(this.getPreferenceName());
        this.loadGradientValues(preferenceValue);
    }

    private void loadGradientValues(String preferenceValue) {
        GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceValue);
        this.color1 = gradientPreferenceConverter.getColor1();
        this.style = gradientPreferenceConverter.getStyle();
        this.transparency = gradientPreferenceConverter.getTransparency();
    }

    protected void doLoadDefault() {
        String preferenceValue = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.loadGradientValues(preferenceValue);
    }

    protected void doStore() {
        GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(this.color1, this.color2, this.style, this.transparency);
        this.getPreferenceStore().setValue(this.getPreferenceName(), gradientPreferenceConverter.getPreferenceValue());
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void dispose() {
        this.disposeButtonImage();
        super.dispose();
    }

    protected void disposeButtonImage() {
        Image imageColor1;
        if (this.colorButton != null && !this.colorButton.isDisposed() && (imageColor1 = this.colorButton.getImage()) != null && !imageColor1.isDisposed()) {
            imageColor1.dispose();
        }
    }

    protected void setButtonImage(RGB rgb) {
        Image image = this.colorButton.getImage();
        if (image != null) {
            image.dispose();
        }
        Display display = this.colorButton.getParent().getShell().getDisplay();
        Color color = new Color((Device)display, rgb);
        image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle rect = image.getBounds();
        gc.fillRectangle(rect);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        color.dispose();
        this.colorButton.setImage(image);
    }

    private RGB changeColor() {
        ColorPalettePopup popup = new ColorPalettePopup(this.colorButton.getParent().getShell(), 25);
        Rectangle r = this.colorButton.getBounds();
        Point location = this.colorButton.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
            return null;
        }
        RGB rgb = popup.getSelectedColor();
        this.setButtonImage(rgb);
        return rgb;
    }

    public void setEnabled(boolean enabled) {
        this.colorButton.setEnabled(enabled);
        this.horizontalStyleButton.setEnabled(enabled);
        this.transparencyValueSpinner.setEnabled(enabled);
        this.verticalStyleButton.setEnabled(enabled);
    }
}

