/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.validation.quickfix;

import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.papyrus.sysml16.validation.quickfix.ConsumerElementMarkerResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class SysMLMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker mk) {
        block42: {
            try {
                Object source = mk.getAttribute("source");
                if (!(source instanceof String)) break block42;
                switch ((String)source) {
                    case "org.eclipse.papyrus.sysml16.validation.constraint.discrete.nocontinuous": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Element>("Unapply stereotype Continuous", element -> {
                            EObject eObject = element.unapplyStereotype(element.getAppliedStereotype("SysML::Activities::Continuous"));
                        }), new ConsumerElementMarkerResolution<Element>("Unapply stereotype Discrete", element -> {
                            EObject eObject = element.unapplyStereotype(element.getAppliedStereotype("SysML::Activities::Discrete"));
                        })};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.requirement.emptyownedattribute": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Element>("Remove all attributes from Requirement", element -> element.getOwnedElements().forEach(Element::destroy))};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.verify.supplier": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Element>("Delete element", Element::destroy)};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.rate.parameterisstream": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Parameter>("Set stream to true", parameter -> parameter.setIsStream(true))};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.block.specialization": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Element>("Apply Block stereotype", element -> {
                            EObject eObject = element.applyStereotype(element.getApplicableStereotype("SysML::Blocks::Block"));
                        })};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.propertyspecifictype.missingname": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Classifier>("Empty classifier name", classifier -> classifier.setName(null))};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.requirement.nogeneralization": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Class>("Destroy the generalisation", clazz -> clazz.getGeneralizations().forEach(Element::destroy))};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.connectorproperty.onlyonblock": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Property>("Apply Block stereotype on owner", property -> {
                            EObject eObject = property.getOwner().applyStereotype(property.getOwner().getApplicableStereotype("SysML::Blocks::Block"));
                        })};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.requirement.notype": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Class>("Remove type", clazz -> {
                            CrossReferenceAdapter crossReferenceAdapter = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)TransactionUtil.getEditingDomain((EObject)clazz).getResourceSet());
                            Set inverseReferencers = crossReferenceAdapter.getInverseReferencers((EObject)clazz, UMLPackage.eINSTANCE.getTypedElement_Type(), null);
                            if (inverseReferencers != null && !inverseReferencers.isEmpty()) {
                                for (Object object : inverseReferencers) {
                                    if (!(object instanceof Property)) continue;
                                    ((Property)object).setType(null);
                                }
                            }
                        }), new ConsumerElementMarkerResolution<Class>("Unapply stereotype Requirement", clazz -> {
                            EObject eObject = clazz.unapplyStereotype(clazz.getAppliedStereotype("SysML::Requirements::Requirement"));
                        })};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.distributedproperty.typedby": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Property>("Apply Block stereotype on owner", property -> Optional.ofNullable(property.getOwner().getApplicableStereotype("SysML::Blocks::Block")).ifPresent(applicableStereotype -> {
                            EObject eObject = property.getOwner().applyStereotype(applicableStereotype);
                        })), new ConsumerElementMarkerResolution<Property>("Apply ValueType stereotype on owner", property -> Optional.ofNullable(property.getOwner().getApplicableStereotype("SysML::Blocks::ValueType")).ifPresent(applicableStereotype -> {
                            EObject eObject = property.getOwner().applyStereotype(applicableStereotype);
                        }))};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.viewpoint.ownedview": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Class>("Create View operation", clazz -> {
                            Operation operation = clazz.createOwnedOperation("View", null, null);
                            operation.applyStereotype(operation.getApplicableStereotype("StandardProfile::Create"));
                        })};
                    }
                    case "org.eclipse.papyrus.sysml16.validation.constraint.block.property.asssociationend": {
                        return new IMarkerResolution[]{new ConsumerElementMarkerResolution<Property>("Create association for Property", property -> {
                            Association association = UMLFactory.eINSTANCE.createAssociation();
                            association.setPackage(property.getNearestPackage());
                            association.getMemberEnds().add(property);
                            Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                            targetProperty.setType((Type)property.getClass_());
                            association.getOwnedEnds().add((Object)targetProperty);
                            association.getMemberEnds().add((Object)targetProperty);
                            property.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                        })};
                    }
                }
            }
            catch (CoreException e) {
                return new IMarkerResolution[0];
            }
        }
        return new IMarkerResolution[0];
    }
}

