/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.CommandCategorySelectionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.CommandIconDialogEditor;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CommandEditor
extends AbstractComponentEditor<MCommand> {
    private Composite composite;
    private EMFDataBindingContext context;
    private StackLayout stackLayout;
    private final List<Action> actions = new ArrayList<Action>();
    private MessageFormat newCommandParameterName;
    @Inject
    private IEclipseContext eclipseContext;

    @Inject
    public CommandEditor() {
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.CommandEditor_AddCommandParameter, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.CommandParameter")){

            public void run() {
                CommandEditor.this.handleAddCommandParameter();
            }
        });
        this.newCommandParameterName = new MessageFormat(this.Messages.CommandEditor_NewCommandParameter);
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Command");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.CommandEditor_Label;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.CommandEditor_Description;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, (IObservableValue<MCommand>)this.getMaster(), false);
                this.createForm(this.composite, this.context, (IObservableValue<MCommand>)this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, (IObservableValue<MCommand>)this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        this.getMaster().setValue((Object)((MCommand)object));
        this.enableIdGenerator(CommandsPackageImpl.Literals.COMMAND__COMMAND_NAME, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, null);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, IObservableValue<MCommand> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, this.Messages.ModelTooling_CommandId_tooltip, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()), this.Messages.ModelTooling_Empty_Warning);
        ControlFactory.createTextField(parent, this.Messages.CommandEditor_Name, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.commandName(this.getEditingDomain()));
        ControlFactory.createTextField(parent, this.Messages.CommandEditor_LabelDescription, master, context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.commandDescription(this.getEditingDomain()));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.CommandEditor_Category);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        t.setEditable(false);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.category().value(E4Properties.elementId(this.getEditingDomain())).observeDetail(this.getMaster()));
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandCategorySelectionDialog dialog = new CommandCategorySelectionDialog(b.getShell(), CommandEditor.this.getEditor().getModelProvider(), (MCommand)CommandEditor.this.getMaster().getValue(), CommandEditor.this.Messages);
                dialog.open();
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.CommandEditor_IconURI);
        l.setLayoutData((Object)new GridData());
        l.setToolTipText(this.Messages.CommandEditor_IconURI_Tooltip);
        t = new Text(parent, 2048);
        ControlFactory.TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.commandIcon(this.getEditingDomain()).observeDetail(this.getMaster()));
        new ImageTooltip((Control)t, this.Messages, this);
        final Button b2 = ControlFactory.createFindButton(parent, this.resourcePool);
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandIconDialogEditor dialog = new CommandIconDialogEditor(b2.getShell(), CommandEditor.this.eclipseContext, CommandEditor.this.project, CommandEditor.this.getEditingDomain(), (MCommand)CommandEditor.this.getMaster().getValue(), CommandEditor.this.Messages);
                dialog.open();
            }
        });
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), (AbstractComponentEditor)this, (EStructuralFeature)CommandsPackageImpl.Literals.COMMAND__PARAMETERS){

            @Override
            protected void addPressed() {
                CommandEditor.this.handleAddCommandParameter();
            }

            @Override
            protected List<?> getContainerChildren(Object master) {
                return ((MCommand)master).getParameters();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(this.Messages.CommandEditor_Parameters);
        TableViewer viewer = pickList.getList();
        viewer.setInput((Object)E4Properties.commandParameters(this.getEditingDomain()).observeDetail(this.getMaster()));
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        this.createContributedEditorTabs(folder, context, this.getMaster(), MCommand.class);
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList<?> getChildList(Object element) {
        return E4Properties.commandParameters(this.getEditingDomain()).observe((Object)((MCommand)element));
    }

    @Override
    public String getDetailLabel(Object element) {
        MCommand cmd = (MCommand)element;
        if (cmd.getCommandName() != null && cmd.getCommandName().trim().length() > 0) {
            return this.translate(cmd.getCommandName());
        }
        return cmd.getElementId();
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{CommandsPackageImpl.Literals.COMMAND__COMMAND_NAME})};
    }

    protected void handleAddCommandParameter() {
        MCommandParameter param = MCommandsFactory.INSTANCE.createCommandParameter();
        this.setElementId(param);
        param.setName(this.newCommandParameterName.format(new Object[]{this.getParameterCount()}));
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.COMMAND__PARAMETERS, (Object)param);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(param);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    private int getParameterCount() {
        EObject command = (EObject)this.getMaster().getValue();
        List commandParameters = (List)command.eGet((EStructuralFeature)CommandsPackageImpl.Literals.COMMAND__PARAMETERS);
        return commandParameters.size();
    }
}

