/**
 * Copyright (c) 2006, 2010, 2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Dmitry Stadnik (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.diagram.editparts;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import diagram.editparts.ChildNodeLabelEditPart;
import diagram.editparts.CompartmentEditPart;
import diagram.editparts.DiagramEditPart;
import diagram.editparts.ExternalNodeLabelEditPart;
import diagram.editparts.LinkEditPart;
import diagram.editparts.LinkLabelEditPart;
import diagram.editparts.NodeEditPart;
import diagram.editparts.NodeLabelEditPart;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class EditPartFactory {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private CodeStyle _codeStyle;
  
  @Inject
  private ChildNodeLabelEditPart childNodeLabelEditPart;
  
  @Inject
  private NodeEditPart nodeEditPart;
  
  @Inject
  private LinkEditPart linkEditPart;
  
  @Inject
  private LinkLabelEditPart linkLabelEditPart;
  
  @Inject
  private ExternalNodeLabelEditPart externalNodeLabelEditPart;
  
  @Inject
  private CompartmentEditPart compartmentEditPart;
  
  @Inject
  private NodeLabelEditPart nodeLabelEditPart;
  
  @Inject
  private DiagramEditPart diagramEditPart;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartFactoryClassName = it.getEditPartFactoryClassName();
    _builder.append(_editPartFactoryClassName);
    return _builder;
  }
  
  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _editPartsPackageName = it.getEditPartsPackageName();
    _builder.append(_editPartsPackageName);
    return _builder;
  }
  
  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }
  
  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence EditPartFactory(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" implements org.eclipse.gef.EditPartFactory {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createEditPartMethod = this.createEditPartMethod(it);
    _builder.append(_createEditPartMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _createUnrecognizedEditPart = this.createUnrecognizedEditPart(it);
    _builder.append(_createUnrecognizedEditPart, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _textCellEditorLocator = this.getTextCellEditorLocator(it);
    _builder.append(_textCellEditorLocator, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence createEditPartMethod(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.gef.EditPart createEditPart(org.eclipse.gef.EditPart context, Object model) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (model instanceof org.eclipse.gmf.runtime.notation.View) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.gmf.runtime.notation.View view = (org.eclipse.gmf.runtime.notation.View) model;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (");
    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it);
    _builder.append(_visualIDMethodCall, "\t\t");
    _builder.append("(view)) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    CharSequence _createEditPart = this.createEditPart(it);
    _builder.append(_createEditPart, "\t\t");
    _builder.newLineIfNotEmpty();
    {
      EList<GenNode> _allNodes = it.getAllNodes();
      for(final GenNode node : _allNodes) {
        _builder.append("\t\t");
        CharSequence _createEditPart_1 = this.createEditPart(node);
        _builder.append(_createEditPart_1, "\t\t");
        _builder.newLineIfNotEmpty();
        {
          EList<GenNodeLabel> _labels = node.getLabels();
          for(final GenNodeLabel label : _labels) {
            _builder.append("\t\t");
            CharSequence _createEditPart_2 = this.createEditPart(label);
            _builder.append(_createEditPart_2, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    {
      EList<GenCompartment> _compartments = it.getCompartments();
      for(final GenCompartment comp : _compartments) {
        _builder.append("\t\t");
        CharSequence _createEditPart_3 = this.createEditPart(comp);
        _builder.append(_createEditPart_3, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t");
        CharSequence _createEditPart_4 = this.createEditPart(link);
        _builder.append(_createEditPart_4, "\t\t");
        _builder.newLineIfNotEmpty();
        {
          EList<GenLinkLabel> _labels_1 = link.getLabels();
          for(final GenLinkLabel label_1 : _labels_1) {
            _builder.append("\t\t");
            CharSequence _createEditPart_5 = this.createEditPart(label_1);
            _builder.append(_createEditPart_5, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return createUnrecognizedEditPart(context, model);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  private CharSequence createEditPart(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
    _builder.append(_caseVisualID);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return new ");
    CharSequence _editPartQualifiedClassName = this.getEditPartQualifiedClassName(it);
    _builder.append(_editPartQualifiedClassName, "\t");
    _builder.append("(view);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence createUnrecognizedEditPart(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("private org.eclipse.gef.EditPart createUnrecognizedEditPart(org.eclipse.gef.EditPart context, Object model) {");
    _builder.newLine();
    _builder.append(" \t");
    _builder.append("// Handle creation of unrecognized child node EditParts here");
    _builder.newLine();
    _builder.append(" \t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence getTextCellEditorLocator(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.gef.tools.CellEditorLocator getTextCellEditorLocator(org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart source) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (source.getFigure() instanceof org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure){");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return new MultilineCellEditorLocator((org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure) source.getFigure());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator.CellEditorLocatorAccess.INSTANCE.getTextCellEditorLocator(source);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("static private class MultilineCellEditorLocator implements org.eclipse.gef.tools.CellEditorLocator {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_1 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("private org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure multilineEditableFigure;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_2 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public MultilineCellEditorLocator(org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure figure) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("this.multilineEditableFigure = figure;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_3 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_3, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.papyrus.uml.diagram.common.figure.node.IMultilineEditableFigure getMultilineEditableFigure() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return multilineEditableFigure;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedClassComment_4 = this._common.generatedClassComment();
    _builder.append(_generatedClassComment_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideI = this._codeStyle.overrideI(it);
    _builder.append(_overrideI, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public void relocate(org.eclipse.jface.viewers.CellEditor celleditor) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.swt.widgets.Text text = (org.eclipse.swt.widgets.Text) celleditor.getControl();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("org.eclipse.draw2d.geometry.Rectangle rect = getMultilineEditableFigure().getBounds().getCopy();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("rect.x=getMultilineEditableFigure().getEditionLocation().x;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("rect.y=getMultilineEditableFigure().getEditionLocation().y;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("getMultilineEditableFigure().translateToAbsolute(rect);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (getMultilineEditableFigure().getText().length() > 0) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("rect.setSize(new org.eclipse.draw2d.geometry.Dimension(text.computeSize(rect.width, org.eclipse.swt.SWT.DEFAULT)));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if (!rect.equals(new org.eclipse.draw2d.geometry.Rectangle(text.getBounds()))) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("text.setBounds(rect.x, rect.y, rect.width, rect.height);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.nodeEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenLink it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.linkEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenCompartment it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.compartmentEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.diagramEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenExternalNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.externalNodeLabelEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenNodeLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.nodeLabelEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenLinkLabel it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.linkLabelEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  protected CharSequence _getEditPartQualifiedClassName(final GenChildLabelNode it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.childNodeLabelEditPart.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }
  
  public CharSequence getEditPartQualifiedClassName(final GenCommonBase it) {
    if (it instanceof GenChildLabelNode) {
      return _getEditPartQualifiedClassName((GenChildLabelNode)it);
    } else if (it instanceof GenCompartment) {
      return _getEditPartQualifiedClassName((GenCompartment)it);
    } else if (it instanceof GenExternalNodeLabel) {
      return _getEditPartQualifiedClassName((GenExternalNodeLabel)it);
    } else if (it instanceof GenNode) {
      return _getEditPartQualifiedClassName((GenNode)it);
    } else if (it instanceof GenDiagram) {
      return _getEditPartQualifiedClassName((GenDiagram)it);
    } else if (it instanceof GenLink) {
      return _getEditPartQualifiedClassName((GenLink)it);
    } else if (it instanceof GenLinkLabel) {
      return _getEditPartQualifiedClassName((GenLinkLabel)it);
    } else if (it instanceof GenNodeLabel) {
      return _getEditPartQualifiedClassName((GenNodeLabel)it);
    } else if (it != null) {
      return _getEditPartQualifiedClassName(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
