/**
 * Copyright (c) 2007-2013, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program && the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, && is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Alexander Shatalin (Borland) - initial API && implementation
 * Michael Golubev (Borland) - [243151] explicit source/target for links
 *                           - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt.diagram.editpolicies;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLink;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLinkEnd;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.papyrus.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.GenModelUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class Utils_qvto {
  @Inject
  @Extension
  private LinkUtils_qvto _linkUtils_qvto;
  
  @Inject
  @Extension
  private GenModelUtils_qvto _genModelUtils_qvto;
  
  public boolean hasChildrenOrCompartments(final GenNode node) {
    return ((!node.getChildNodes().isEmpty()) || (!node.getCompartments().isEmpty()));
  }
  
  public String getContainerVariable(final TypeLinkModelFacet modelFacet) {
    String _xifexpression = null;
    GenFeature _sourceMetaFeature = modelFacet.getSourceMetaFeature();
    boolean _tripleNotEquals = (_sourceMetaFeature != null);
    if (_tripleNotEquals) {
      _xifexpression = "container";
    } else {
      _xifexpression = "source";
    }
    return _xifexpression;
  }
  
  public Iterable<GenLinkConstraints> getValidLinkConstraints(final GenDiagram diagram) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink l) {
        return Boolean.valueOf(((l.getCreationConstraints() != null) && l.getCreationConstraints().isValid()));
      }
    };
    Iterable<GenLink> goodLinks = IterableExtensions.<GenLink>filter(diagram.getLinks(), _function);
    final Function1<GenLink, GenLinkConstraints> _function_1 = new Function1<GenLink, GenLinkConstraints>() {
      @Override
      public GenLinkConstraints apply(final GenLink l) {
        return l.getCreationConstraints();
      }
    };
    return IterableExtensions.<GenLink, GenLinkConstraints>map(goodLinks, _function_1);
  }
  
  public Iterable<GenLink> getAllPotentialLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this.isCreationAllowed(link));
      }
    };
    return IterableExtensions.<GenLink>filter(this.getAllRelatedLinks(linkEnd), _function);
  }
  
  public Iterable<GenLink> getReroutableTypeLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this._linkUtils_qvto.isTypeLink(link));
      }
    };
    return IterableExtensions.<GenLink>filter(this.getAllRelatedReroutableLinks(linkEnd), _function);
  }
  
  public Iterable<GenLink> getReroutableRefLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(Utils_qvto.this._linkUtils_qvto.isRefLink(link));
      }
    };
    return IterableExtensions.<GenLink>filter(this.getAllRelatedReroutableLinks(linkEnd), _function);
  }
  
  /**
   * XXX: [MG] Revisit for xtend:
   * XXX [MG]: again, it would be better to use linkEnd.incomingLinks.union(linkEnd.outgoingLinks).toList()
   * but it will change the ordering && produce meaningless diff in the generated code
   */
  public Iterable<GenLink> getAllRelatedLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf((Utils_qvto.this._linkUtils_qvto.canBeSource(link, linkEnd) || Utils_qvto.this._linkUtils_qvto.canBeTarget(link, linkEnd)));
      }
    };
    return IterableExtensions.<GenLink>filter(linkEnd.getDiagram().getLinks(), _function);
  }
  
  public Iterable<GenLink> getAllRelatedReroutableLinks(final GenLinkEnd linkEnd) {
    final Function1<GenLink, Boolean> _function = new Function1<GenLink, Boolean>() {
      @Override
      public Boolean apply(final GenLink link) {
        return Boolean.valueOf(((Utils_qvto.this._linkUtils_qvto.canBeSource(link, linkEnd) && link.isSourceReorientingAllowed()) || (Utils_qvto.this._linkUtils_qvto.canBeTarget(link, linkEnd) && link.isTargetReorientingAllowed())));
      }
    };
    return IterableExtensions.<GenLink>filter(linkEnd.getDiagram().getLinks(), _function);
  }
  
  public boolean isCreationAllowed(final GenLink link) {
    return ((link.getModelFacet() != null) && (link.isOutgoingCreationAllowed() || link.isIncomingCreationAllowed()));
  }
  
  public boolean createStartLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.createStartOutgoingLinkCommand(link, linkEnd) || this.createStartIncomingLinkCommand(link, linkEnd));
  }
  
  public boolean createStartOutgoingLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.isSelf(link, linkEnd) || (this.isOutgoing(link, linkEnd) && link.isOutgoingCreationAllowed()));
  }
  
  public boolean createStartIncomingLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.isIncoming(link, linkEnd) && link.isIncomingCreationAllowed());
  }
  
  public boolean createCompleteLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.createCompleteIncomingLinkCommand(link, linkEnd) || this.createCompleteOutgoingLinkCommand(link, linkEnd));
  }
  
  public boolean createCompleteIncomingLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.isSelf(link, linkEnd) || (this.isIncoming(link, linkEnd) && link.isOutgoingCreationAllowed()));
  }
  
  public boolean createCompleteOutgoingLinkCommand(final GenLink link, final GenLinkEnd linkEnd) {
    return (this.isOutgoing(link, linkEnd) && link.isIncomingCreationAllowed());
  }
  
  public boolean checkSource(final boolean reversedRequest, final boolean isCompleteCommand) {
    return ((!reversedRequest) || isCompleteCommand);
  }
  
  public boolean checkTarget(final boolean reversedRequest, final boolean isCompleteCommand) {
    return (reversedRequest || isCompleteCommand);
  }
  
  private boolean isSelf(final GenLink link, final GenLinkEnd linkEnd) {
    return (this._linkUtils_qvto.canBeSource(link, linkEnd) && this._linkUtils_qvto.canBeTarget(link, linkEnd));
  }
  
  private boolean isOutgoing(final GenLink link, final GenLinkEnd linkEnd) {
    return (this._linkUtils_qvto.canBeSource(link, linkEnd) && (!this._linkUtils_qvto.canBeTarget(link, linkEnd)));
  }
  
  private boolean isIncoming(final GenLink link, final GenLinkEnd linkEnd) {
    return (this._linkUtils_qvto.canBeTarget(link, linkEnd) && (!this._linkUtils_qvto.canBeSource(link, linkEnd)));
  }
  
  /**
   * if child's containment feature comes from the node, assume deletion of the parent would delete the child.
   */
  public boolean isDirectlyOwned(final GenChildNode child, final GenNode genNode) {
    TypeModelFacet childFacet = child.getModelFacet();
    if (((childFacet == null) || (genNode.getModelFacet() == null))) {
      return false;
    }
    GenFeature _containmentMetaFeature = childFacet.getContainmentMetaFeature();
    boolean _tripleEquals = (_containmentMetaFeature == null);
    if (_tripleEquals) {
      return false;
    }
    return this._genModelUtils_qvto.isSuperTypeOf(childFacet.getContainmentMetaFeature().getGenClass(), genNode.getModelFacet().getMetaClass());
  }
  
  public Boolean containsCreateStartLinkCommand(final GenLinkEnd it) {
    Iterable<GenLink> _allPotentialLinks = this.getAllPotentialLinks(it);
    for (final GenLink l : _allPotentialLinks) {
      boolean _createStartLinkCommand = this.createStartLinkCommand(l, it);
      if (_createStartLinkCommand) {
        return Boolean.valueOf(true);
      }
    }
    return Boolean.valueOf(false);
  }
  
  public Boolean containsCreateCompleteLinkCommand(final GenLinkEnd it) {
    Iterable<GenLink> _allPotentialLinks = this.getAllPotentialLinks(it);
    for (final GenLink l : _allPotentialLinks) {
      boolean _createCompleteLinkCommand = this.createCompleteLinkCommand(l, it);
      if (_createCompleteLinkCommand) {
        return Boolean.valueOf(true);
      }
    }
    return Boolean.valueOf(false);
  }
}
