/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.custom.figure.nodes;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.deployment.custom.figure.nodes.NodeLayoutManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class NodeFigure
extends NodeNamedElementFigure {
    public final int SPACE_FOR_PERSPECTIVE = 15;
    private RectangleFigure shapeCompartment;
    protected Label iconNode = null;

    public NodeFigure() {
        this.createContent();
    }

    public NodeFigure(String taggedLabelValue) {
        super(taggedLabelValue);
        this.createContent();
    }

    protected void createContent() {
        this.setLayoutManager((LayoutManager)new NodeLayoutManager(this));
        this.setOpaque(false);
        this.shapeCompartment = new RectangleFigure();
        this.shapeCompartment.setBorder(null);
        this.add((IFigure)this.shapeCompartment);
        this.setBorder(null);
        this.getCompositeCompartmentFigure().setFill(false);
    }

    public void setTagIcon(Image image) {
        this.iconNode = new Label();
        this.iconNode.setIcon(image);
        this.add((IFigure)this.iconNode);
    }

    public ShapeCompartmentFigure getGMFCompositeContainer() {
        if (this.shapeCompartment.getChildren().size() > 0) {
            return (ShapeCompartmentFigure)this.shapeCompartment.getChildren().get(0);
        }
        return null;
    }

    public RectangleFigure getCompositeCompartmentFigure() {
        return this.shapeCompartment;
    }

    public Color getGradientColor() {
        return this.getForegroundColor();
    }

    public void setShadow(boolean shadow) {
    }

    public void setLineWidth(int w) {
        this.getCompositeCompartmentFigure().setLineWidth(w);
        super.setLineWidth(w);
    }

    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
    }

    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (this.isUsingGradient()) {
            this.applyTransparency(graphics);
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            boolean isVertical = this.getGradientStyle() == 0;
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.fillGradient(this.getCompositeCompartmentFigure().getBounds(), isVertical);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getBorderColor());
            graphics.fillRectangle(this.getCompositeCompartmentFigure().getBounds());
        }
        graphics.setForegroundColor(this.getBorderColor());
        graphics.setLineWidth(this.getLineWidth());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Rectangle bounds = this.getBounds();
        graphics.pushState();
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setLineWidth(1);
        graphics.drawRectangle(bounds.x, bounds.y + 15, bounds.width - 15 - 1, bounds.height - 15 - 1);
        graphics.drawLine(new Point(bounds.x, bounds.y + 15), new Point(bounds.x + 15, bounds.y));
        graphics.drawLine(new Point(bounds.x + bounds.width - 15 - 1, bounds.y + 15), new Point(bounds.x - 1 + bounds.width, bounds.y));
        graphics.drawLine(new Point(bounds.x + bounds.width - 15 - 1, bounds.y + bounds.height), new Point(bounds.x + bounds.width - 1, bounds.y + bounds.height - 15));
        graphics.drawLine(new Point(bounds.x + 15, bounds.y), new Point(bounds.x + bounds.width, bounds.y));
        graphics.drawLine(new Point(bounds.x + bounds.width - 1, bounds.y), new Point(bounds.x + bounds.width - 1, bounds.y + bounds.height - 15));
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.popState();
    }
}

