/*
 * Decompiled with CFR 0.152.
 */
package xpt.providers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import metamodel.MetaModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditContext;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRoot;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenAuditedMetricTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDomainAttributeTarget;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenJavaExpressionProvider;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ValueExpression;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Common_qvto;
import xpt.GenAuditRoot_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.expressions.getExpression;
import xpt.providers.MetricProvider;

@Singleton
public class ValidationProvider {
    @Inject
    @Extension
    private Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private GenAuditRoot_qvto _genAuditRoot_qvto;
    @Inject
    private Activator xptActivator;
    @Inject
    private MetaModel xptMetaModel;
    @Inject
    private getExpression xptGetExpression;
    @Inject
    private MetricProvider xptMetricProvider;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    @Extension
    private CodeStyle _codeStyle;

    public CharSequence className(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _validationProviderClassName = it.getValidationProviderClassName();
        _builder.append(_validationProviderClassName);
        return _builder;
    }

    public CharSequence packageName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        String _providersPackageName = it.getProvidersPackageName();
        _builder.append(_providersPackageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence ValidationProvider(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _constraintsActive = this.constraintsActive(it);
        _builder.append((Object)_constraintsActive, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _shouldConstraintsBePrivate = this.shouldConstraintsBePrivate(it);
        _builder.append((Object)_shouldConstraintsBePrivate, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _runWithActiveConstraints = this.runWithActiveConstraints(it);
        _builder.append((Object)_runWithActiveConstraints, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _isInDefaultEditorContext = this.isInDefaultEditorContext(it);
        _builder.append((Object)_isInDefaultEditorContext, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _selectors = this.selectors(it.getEditorGen().getAudits());
        _builder.append((Object)_selectors, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _strategy_support = this.strategy_support(it);
        _builder.append((Object)_strategy_support, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _constraintAdapters = this.constraintAdapters(it.getEditorGen().getAudits(), it);
        _builder.append((Object)_constraintAdapters, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence constraintsActive(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("private static boolean constraintsActive = false;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence shouldConstraintsBePrivate(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static boolean shouldConstraintsBePrivate() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence runWithActiveConstraints(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static void runWithConstraints(org.eclipse.emf.transaction.TransactionalEditingDomain editingDomain, Runnable operation) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("final Runnable op = operation;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Runnable task = new Runnable() {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _overrideI = this._codeStyle.overrideI(it);
        _builder.append((Object)_overrideI, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("public void run() {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("constraintsActive = true;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("op.run();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("} finally {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("constraintsActive = false;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(editingDomain != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("editingDomain.runExclusive(task);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("} catch (Exception e) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
        _builder.append((Object)_qualifiedClassName, "\t\t\t");
        _builder.append(".getInstance().logError(\"Validation failed\", e); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append((Object)_nonNLS, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("task.run();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence selectors(GenAuditRoot it) {
        StringConcatenation _xifexpression = null;
        if (it != null && it.getClientContexts() != null) {
            StringConcatenation _builder = new StringConcatenation();
            EList _clientContexts = it.getClientContexts();
            for (GenAuditContext ctx : _clientContexts) {
                CharSequence _generatedMemberComment = this._common.generatedMemberComment();
                _builder.append((Object)_generatedMemberComment);
                _builder.newLineIfNotEmpty();
                _builder.append("public static class ");
                String _className = ctx.getClassName();
                _builder.append(_className);
                _builder.append(" implements org.eclipse.emf.validation.model.IClientSelector {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
                _builder.append((Object)_generatedMemberComment_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _overrideC = this._codeStyle.overrideC(it);
                _builder.append((Object)_overrideC, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("public boolean selects(Object object) {");
                _builder.newLine();
                boolean _notEmpty = this._common_qvto.notEmpty(Iterables.filter((Iterable)ctx.getRuleTargets(), GenDiagramElementTarget.class));
                if (_notEmpty) {
                    _builder.append("if (isInDefaultEditorContext(object) && object instanceof org.eclipse.gmf.runtime.notation.View) {");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("final String id = ");
                    CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
                    _builder.append((Object)_visualIDMethodCall, "\t");
                    _builder.append("((org.eclipse.gmf.runtime.notation.View) object);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("boolean result = false;");
                    _builder.newLine();
                    Iterable<GenCommonBase> _targetDiagramElements = this._genAuditRoot_qvto.getTargetDiagramElements(ctx);
                    for (GenCommonBase e : _targetDiagramElements) {
                        _builder.append("result = result || ");
                        CharSequence _visualID = VisualIDRegistry.visualID(e);
                        _builder.append((Object)_visualID);
                        _builder.append(".equals(id);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("return result;");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("return false;");
                    _builder.newLine();
                } else {
                    _builder.append("return isInDefaultEditorContext(object);");
                    _builder.newLine();
                }
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
            }
            _xifexpression = _builder;
        }
        return _xifexpression;
    }

    public CharSequence isInDefaultEditorContext(GenDiagram it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static boolean isInDefaultEditorContext(Object object) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(shouldConstraintsBePrivate() && !constraintsActive) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (object instanceof org.eclipse.gmf.runtime.notation.View) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return constraintsActive && ");
        CharSequence _modelID = VisualIDRegistry.modelID(it);
        _builder.append((Object)_modelID, "\t\t");
        _builder.append(".equals(");
        CharSequence _modelIDMethodCall = this.xptVisualIDRegistry.getModelIDMethodCall(it);
        _builder.append((Object)_modelIDMethodCall, "\t\t");
        _builder.append("((org.eclipse.gmf.runtime.notation.View) object));");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence strategy_support(GenDiagram it) {
        StringConcatenation _xifexpression = null;
        boolean _hasDiagramElementTargetRule = this._genAuditRoot_qvto.hasDiagramElementTargetRule(it.getEditorGen().getAudits());
        if (_hasDiagramElementTargetRule) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public static org.eclipse.emf.validation.service.ITraversalStrategy getNotationTraversalStrategy(org.eclipse.emf.validation.service.IBatchValidator validator) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return new CtxSwitchStrategy(validator);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_1);
            _builder.newLineIfNotEmpty();
            _builder.append("private static class CtxSwitchStrategy implements org.eclipse.emf.validation.service.ITraversalStrategy {");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_2);
            _builder.newLineIfNotEmpty();
            _builder.append("private org.eclipse.emf.validation.service.ITraversalStrategy defaultStrategy;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_3 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_3);
            _builder.newLineIfNotEmpty();
            _builder.append("private String currentSemanticCtxId;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_4 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_4);
            _builder.newLineIfNotEmpty();
            _builder.append("private boolean ctxChanged = true;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_5 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_5);
            _builder.newLineIfNotEmpty();
            _builder.append("private org.eclipse.emf.ecore.EObject currentTarget;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_6 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_6);
            _builder.newLineIfNotEmpty();
            _builder.append("private org.eclipse.emf.ecore.EObject preFetchedNextTarget;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_7 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_7);
            _builder.newLineIfNotEmpty();
            _builder.append("private final String[] contextSwitchingIdentifiers;");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_8 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_8);
            _builder.newLineIfNotEmpty();
            _builder.append("CtxSwitchStrategy(org.eclipse.emf.validation.service.IBatchValidator validator) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this.defaultStrategy = validator.getDefaultTraversalStrategy();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this.contextSwitchingIdentifiers = new String[] {");
            _builder.newLine();
            _builder.append("\t\t");
            Iterable<GenCommonBase> _allTargetDiagramElements = this._genAuditRoot_qvto.getAllTargetDiagramElements(it.getEditorGen().getAudits());
            boolean _hasElements = false;
            for (GenCommonBase e : _allTargetDiagramElements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t\t");
                }
                CharSequence _visualID = VisualIDRegistry.visualID(e);
                _builder.append((Object)_visualID, "\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("};");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("java.util.Arrays.sort(this.contextSwitchingIdentifiers);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_9 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_9);
            _builder.newLineIfNotEmpty();
            _builder.append("public void elementValidated(org.eclipse.emf.ecore.EObject element, org.eclipse.core.runtime.IStatus status) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("defaultStrategy.elementValidated(element, status);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_10 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_10);
            _builder.newLineIfNotEmpty();
            _builder.append("public boolean hasNext() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return defaultStrategy.hasNext();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_11 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_11);
            _builder.newLineIfNotEmpty();
            _builder.append("public boolean isClientContextChanged() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (preFetchedNextTarget == null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("preFetchedNextTarget = next();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("prepareNextClientContext(preFetchedNextTarget);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ctxChanged;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_12 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_12);
            _builder.newLineIfNotEmpty();
            _builder.append("public org.eclipse.emf.ecore.EObject next() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.emf.ecore.EObject nextTarget = preFetchedNextTarget;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (nextTarget == null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("nextTarget = defaultStrategy.next();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("this.preFetchedNextTarget = null;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return this.currentTarget = nextTarget;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_13 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_13);
            _builder.newLineIfNotEmpty();
            _builder.append("public void startTraversal(java.util.Collection traversalRoots, org.eclipse.core.runtime.IProgressMonitor monitor) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("defaultStrategy.startTraversal(traversalRoots, monitor);");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            CharSequence _generatedMemberComment_14 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_14);
            _builder.newLineIfNotEmpty();
            _builder.append("private void prepareNextClientContext(org.eclipse.emf.ecore.EObject nextTarget) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("if (nextTarget != null && currentTarget != null) {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("if (nextTarget instanceof org.eclipse.gmf.runtime.notation.View) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("final String id = ");
            CharSequence _visualIDMethodCall = this.xptVisualIDRegistry.getVisualIDMethodCall(it.getEditorGen().getDiagram());
            _builder.append((Object)_visualIDMethodCall, "\t\t\t");
            _builder.append("((org.eclipse.gmf.runtime.notation.View) nextTarget);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("String nextSemanticId = (id != null && java.util.Arrays.binarySearch(contextSwitchingIdentifiers, id) >= 0) ? id : null;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if ((currentSemanticCtxId != null && currentSemanticCtxId != nextSemanticId) || (nextSemanticId != null && nextSemanticId != currentSemanticCtxId)) {");
            _builder.newLine();
            _builder.append("\t\t\t\t");
            _builder.append("this.ctxChanged = true;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("currentSemanticCtxId = nextSemanticId;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// context of domain model");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("this.ctxChanged = currentSemanticCtxId != null;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("currentSemanticCtxId = null;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("this.ctxChanged = false;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _xifexpression = _builder;
        }
        return _xifexpression;
    }

    public CharSequence constraintAdapters(GenAuditRoot it, GenDiagram diagram) {
        StringConcatenation _builder = new StringConcatenation();
        if (it != null) {
            boolean _tripleNotEquals;
            GenExpressionProviderContainer _expressionProviders = diagram.getEditorGen().getExpressionProviders();
            boolean bl = _tripleNotEquals = _expressionProviders != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function = a -> a.isRequiresConstraintAdapter();
                Iterable _filter = IterableExtensions.filter((Iterable)it.getRules(), (Functions.Function1)_function);
                for (GenAuditRule next : _filter) {
                    CharSequence _constraintAdapter = this.constraintAdapter(next, diagram.getEditorGen().getExpressionProviders());
                    _builder.append((Object)_constraintAdapter);
                    _builder.newLineIfNotEmpty();
                }
                Functions.Function1 _function_1 = a -> a.isRequiresConstraintAdapter();
                boolean _exists = IterableExtensions.exists((Iterable)it.getRules(), (Functions.Function1)_function_1);
                if (_exists) {
                    CharSequence _constraintAdapters_formatMethod = this.constraintAdapters_formatMethod(it);
                    _builder.append((Object)_constraintAdapters_formatMethod);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence constraintAdapter(GenAuditRule it, GenExpressionProviderContainer container) {
        StringConcatenation _builder = new StringConcatenation();
        if (it.getTarget() != null && it.getTarget().getContext() != null) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            _builder.append("public static class ");
            String _constraintAdapterLocalClassName = it.getConstraintAdapterLocalClassName();
            _builder.append(_constraintAdapterLocalClassName);
            _builder.append(" extends org.eclipse.emf.validation.AbstractModelConstraint {");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("public org.eclipse.core.runtime.IStatus validate(org.eclipse.emf.validation.IValidationContext ctx) {");
            _builder.newLine();
            _builder.append("\t\t");
            CharSequence _constraintAdapter_initContext = this.constraintAdapter_initContext(it.getTarget(), it);
            _builder.append((Object)_constraintAdapter_initContext, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            CharSequence _constraintAdapter_validateMethod = this.constraintAdapter_validateMethod(it.getRule().getProvider(), it);
            _builder.append((Object)_constraintAdapter_validateMethod, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence constraintAdapters_formatMethod(GenAuditRoot it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("static String formatElement(org.eclipse.emf.ecore.EObject object) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil.getQualifiedName(object, true);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintAdapter_validateMethod(GenExpressionProviderBase it, GenAuditRule audit) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("No idea how to evaluate an audit rule for " + it);
        return _builder;
    }

    protected CharSequence _constraintAdapter_validateMethod(GenExpressionInterpreter it, GenAuditRule audit) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Object result = ");
        CharSequence _expression = this.xptGetExpression.getExpression((GenExpressionProviderBase)it, (ValueExpression)audit.getRule(), audit.getTarget().getContext());
        _builder.append((Object)_expression);
        _builder.append(".evaluate(context);");
        _builder.newLineIfNotEmpty();
        _builder.append("if (result instanceof Boolean && ((Boolean) result).booleanValue()) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return org.eclipse.core.runtime.Status.OK_STATUS;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("return ctx.createFailureStatus(new Object[] { formatElement(ctx.getTarget()) });");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintAdapter_validateMethod(GenJavaExpressionProvider it, GenAuditRule audit) {
        StringConcatenation _builder = new StringConcatenation();
        if (it.isInjectExpressionBody() && !StringExtensions.isNullOrEmpty((String)audit.getRule().getBody())) {
            String _body = audit.getRule().getBody();
            _builder.append(_body);
            _builder.newLineIfNotEmpty();
        } else if (it.isThrowException() || it.isInjectExpressionBody() && StringExtensions.isNullOrEmpty((String)audit.getRule().getBody())) {
            _builder.append("// TODO: put validation code here");
            _builder.newLine();
            _builder.append("// Ensure that you remove @generated tag or use @generated NOT");
            _builder.newLine();
            _builder.append("//");
            _builder.newLine();
            _builder.append("// To construct approprate return value, use ctx.createSuccessStatus()");
            _builder.newLine();
            _builder.append("// or ctx.createFailureStatus(...)");
            _builder.newLine();
            _builder.append("throw new java.lang.UnsupportedOperationException(\"No user java implementation provided for #validate(IValidationContext) operation\"); ");
            CharSequence _nonNLS = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("return ctx.createFailureStatus(new Object[] { \"No user java implementation provided for #validate(IValidationContext) operation\" }); ");
            CharSequence _nonNLS_1 = this._common.nonNLS(1);
            _builder.append((Object)_nonNLS_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _constraintAdapter_initContext(GenAuditable it, GenAuditRule audit) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _DeclareAndAssign = this.xptMetaModel.DeclareAndAssign(it.getContext(), "context", "ctx.getTarget()", false);
        _builder.append((Object)_DeclareAndAssign);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _constraintAdapter_initContext(GenDomainAttributeTarget it, GenAuditRule audit) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("final Object");
        _builder.append(" context = ctx.getTarget().eGet(");
        CharSequence _MetaFeature = this.xptMetaModel.MetaFeature(it.getAttribute());
        _builder.append((Object)_MetaFeature);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("if (context == null) {");
        _builder.newLine();
        boolean _isNullAsError = it.isNullAsError();
        if (_isNullAsError) {
            _builder.append("return ctx.createFailureStatus(new Object[] { formatElement(ctx.getTarget()) });");
            _builder.newLine();
        } else {
            _builder.append("return org.eclipse.core.runtime.Status.OK_STATUS;");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _constraintAdapter_initContext(GenAuditedMetricTarget it, GenAuditRule audit) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        GenMetricRule _metric = it.getMetric();
        boolean bl = _tripleEquals = _metric == null;
        if (_tripleEquals) {
            _builder.append("final Number context = null /*FIXME: metric target was not correctly specified in the model*/;");
            _builder.newLine();
        } else {
            _builder.append("final Number context = ");
            CharSequence _invokeCalcMethod = this.xptMetricProvider.invokeCalcMethod(it.getMetric(), "ctx.getTarget()", false);
            _builder.append((Object)_invokeCalcMethod);
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence constraintAdapter_validateMethod(GenExpressionProviderBase it, GenAuditRule audit) {
        if (it instanceof GenExpressionInterpreter) {
            return this._constraintAdapter_validateMethod((GenExpressionInterpreter)it, audit);
        }
        if (it instanceof GenJavaExpressionProvider) {
            return this._constraintAdapter_validateMethod((GenJavaExpressionProvider)it, audit);
        }
        if (it != null) {
            return this._constraintAdapter_validateMethod(it, audit);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, audit).toString());
    }

    public CharSequence constraintAdapter_initContext(GenAuditable it, GenAuditRule audit) {
        if (it instanceof GenAuditedMetricTarget) {
            return this._constraintAdapter_initContext((GenAuditedMetricTarget)it, audit);
        }
        if (it instanceof GenDomainAttributeTarget) {
            return this._constraintAdapter_initContext((GenDomainAttributeTarget)it, audit);
        }
        if (it != null) {
            return this._constraintAdapter_initContext(it, audit);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, audit).toString());
    }
}

