/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GeneralOrderingEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.CustomGeneralOrderingDescriptor;

public class CustomGeneralOrderingEditPart
extends GeneralOrderingEditPart
implements IPapyrusEditPart {
    public CustomGeneralOrderingEditPart(View view) {
        super(view);
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
    }

    @Override
    protected Connection createConnectionFigure() {
        return new CustomGeneralOrderingDescriptor(this.getMapMode());
    }

    @Override
    public CustomGeneralOrderingDescriptor getPrimaryShape() {
        return (CustomGeneralOrderingDescriptor)this.getFigure();
    }

    protected void setLineWidth(int width) {
        this.getPrimaryShape().setLineWidth(width);
    }

    public EditPart getTargetEditPart(Request request) {
        ReconnectRequest rRequest;
        EditPart ep = super.getTargetEditPart(request);
        if (ep != null && ep instanceof ConnectionEditPart && request instanceof ReconnectRequest && this.isCyclicConnectionRequest((ConnectionEditPart)ep, (rRequest = (ReconnectRequest)request).getConnectionEditPart())) {
            return null;
        }
        return ep;
    }

    private boolean isCyclicConnectionRequest(ConnectionEditPart currentConn, ConnectionEditPart reqConn) {
        if (currentConn == null || reqConn == null) {
            return false;
        }
        EditPart source = currentConn.getSource();
        EditPart target = currentConn.getTarget();
        if (reqConn == source || reqConn == target) {
            return true;
        }
        return reqConn == source.getParent() || reqConn == target.getParent();
    }
}

