/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part.CustomStateEditPartTN;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.figures.StateFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateEditPartTN;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateNameEditPartTN;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.State;

public class CustomStateNameEditPartTN
extends StateNameEditPartTN {
    public CustomStateNameEditPartTN(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.removeEditPolicy("PopupBarEditPolicy");
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        this.refreshVisuals();
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        View stateLabelView = (View)this.getModel();
        StateFigure stateFigure = ((StateEditPartTN)this.getParent()).getPrimaryShape();
        if (!(stateLabelView.getElement() instanceof State)) {
            return;
        }
        State state = (State)stateLabelView.getElement();
        View stateView = (View)stateLabelView.eContainer();
        if (stateView == null) {
            return;
        }
        View stateCompartmentView = CustomStateEditPartTN.getStateCompartmentView(stateView);
        if (stateCompartmentView.getChildren().isEmpty()) {
            stateFigure.getStateCompartmentFigure().setVisible(false);
        } else {
            stateFigure.getStateCompartmentFigure().setVisible(true);
        }
        if (state.isSubmachineState()) {
            stateFigure.setSubmachineStateName(String.valueOf(UMLLabelInternationalization.getInstance().getLabel((NamedElement)state)) + " : " + state.getSubmachine().getQualifiedName());
            stateFigure.setIsSubmachineState(true);
        } else {
            stateFigure.setIsSubmachineState(false);
        }
        int width = stateFigure.getBounds().width;
        int height = 0;
        if (stateCompartmentView.isVisible() && stateFigure.getStateCompartmentFigure() != null) {
            stateFigure.validate();
            height = stateFigure.getStateCompartmentFigure().getBounds().y - stateFigure.getBounds().y + 1;
            if (height < 0) {
                height = 0;
            }
        } else {
            height = stateFigure.getNameLabel().getBounds().height;
        }
        int stateHeight = Zone.getHeight(stateView);
        int stateWidth = Zone.getWidth(stateView);
        int stateCompartHeight = Zone.getHeight(stateCompartmentView);
        int dx = width - stateWidth;
        int dy = stateCompartHeight + height - stateHeight;
        int x = Zone.getX(stateView);
        int y = Zone.getY(stateView);
        if (stateHeight != -1 && stateCompartHeight != -1 && width != 0 && dy != 0) {
            dx = dx > 0 ? dx : 0;
            SemanticAdapter adaptableForState = new SemanticAdapter(null, (Object)stateView);
            ChangeBoundsRequest internalResizeRequest = new ChangeBoundsRequest();
            internalResizeRequest.setResizeDirection(16);
            internalResizeRequest.setSizeDelta(new Dimension(dx, dy));
            Rectangle rect = new Rectangle(x, y, stateWidth + dx, stateHeight + dy);
            CustomStateResizeCommand internalResizeCommand = new CustomStateResizeCommand((IAdaptable)adaptableForState, this.getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, internalResizeRequest, rect, true);
            internalResizeCommand.setOptions(Collections.singletonMap("unprotected", Boolean.TRUE));
            try {
                internalResizeCommand.execute(null, null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

