/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.filter.configuration;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.papyrus.infra.emf.nattable.filter.configuration.EEnumFilterCellEditorFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.IFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.IPapyrusMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.filter.configuration.UMLEnumerationMatcherEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLEnumerationEditorFilterConfiguration
extends EEnumFilterCellEditorFilterConfiguration {
    private static final String ID = "org.eclipse.papyrus.uml.nattable.uml.enumeration.checkboxcombo.with.NA";

    public boolean handles(IConfigRegistry registry, Object columnElement) {
        if (UMLTableUtils.isStringRepresentingStereotypeProperty(columnElement)) {
            String string = (String)AxisUtils.getRepresentedElement((Object)columnElement);
            INattableModelManager manager = (INattableModelManager)registry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            Table table = manager.getTable();
            Property prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), AxisUtils.getPropertyId((Object)string));
            if (prop != null) {
                Type type = prop.getType();
                return type instanceof Enumeration;
            }
        }
        return false;
    }

    protected List<Enumerator> getLiteral(IConfigRegistry configRegistry, Object axis) {
        String id = (String)AxisUtils.getRepresentedElement((Object)axis);
        INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        Table table = manager.getTable();
        return UMLTableUtils.getLiteralsToTypeProperty(table.getContext(), id);
    }

    protected IPapyrusMatcherEditorFactory<Object> createPapyrusMatcherFactory() {
        return new IPapyrusMatcherEditorFactory<Object>(){

            public EventList<MatcherEditor<Object>> instantiateMatcherEditors(IColumnAccessor<Object> columnAccessor, Integer columnIndex, Object wantedValue, IConfigRegistry configRegistry) {
                BasicEventList list = new BasicEventList();
                list.add((Object)new UMLEnumerationMatcherEditor(columnAccessor, columnIndex, wantedValue, configRegistry));
                return list;
            }
        };
    }

    protected IFilterValueToMatchManager createFilterValueToMatchManager(String filterConfiguration, List<Enumerator> literals) {
        return new UMLEnumerationFilterValueToMatchManager(filterConfiguration, literals);
    }

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a combo with checkbox to filter UML Enumeration, with N/A value";
    }

    public static class UMLEnumerationFilterValueToMatchManager
    extends EEnumFilterCellEditorFilterConfiguration.EnumeratorFilterValueToMatchManager {
        public UMLEnumerationFilterValueToMatchManager(String filterConfigurationId, List<Enumerator> literals) {
            super(filterConfigurationId, literals);
        }

        public Object getValueToMatch(IConfigRegistry configRegistry, Object axis) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            NamedStyle style = this.getValueToMatchStyle(iaxis);
            if (style != null) {
                if (style instanceof StringListValueStyle) {
                    ArrayList<String> returnedValues = new ArrayList<String>();
                    EList coll = ((StringListValueStyle)style).getStringListValue();
                    for (String string : coll) {
                        if (ICellManager.NOT_AVALAIBLE.equals(string)) {
                            returnedValues.add(string);
                            continue;
                        }
                        for (Enumerator tmp : this.literals) {
                            if (!tmp.getName().equals(string)) continue;
                            returnedValues.add((String)tmp);
                        }
                    }
                    return returnedValues;
                }
                if (style instanceof StringValueStyle) {
                    String val = ((StringValueStyle)style).getStringValue();
                    if (ICellManager.NOT_AVALAIBLE.equals(val)) {
                        return val;
                    }
                    for (Enumerator tmp : this.literals) {
                        if (!tmp.getName().equals(val)) continue;
                        return tmp;
                    }
                }
            }
            return null;
        }

        protected Command getSaveValueToMatchCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis, Object newValue) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            CompoundCommand cc = new CompoundCommand("Set Filter Value Command");
            NamedStyle keyStyle = this.getValueToMatchStyle(iaxis);
            if (newValue instanceof Collection) {
                Command cmd;
                Collection coll = (Collection)newValue;
                if (keyStyle != null && !(keyStyle instanceof StringListValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createStringListValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Object tmp : coll) {
                    if (tmp instanceof String) {
                        values.add((String)tmp);
                        continue;
                    }
                    Assert.isTrue((boolean)(tmp instanceof Enumerator));
                    values.add(((Enumerator)tmp).getName());
                }
                cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringListValueStyle_StringListValue(), values));
            } else {
                Command cmd;
                if (keyStyle != null && !(keyStyle instanceof StringValueStyle) && (cmd = this.getDestroyFilterValueToMatchCommand(domain, configRegistry, axis)) != null && cmd.canExecute()) {
                    cc.append(cmd);
                }
                if (keyStyle == null) {
                    keyStyle = NattablestyleFactory.eINSTANCE.createEObjectValueStyle();
                    keyStyle.setName("filterValueToMatch");
                    cc.append(AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getNamedStyle(), (Object)keyStyle));
                }
                if (newValue instanceof String) {
                    cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)newValue));
                } else {
                    Assert.isTrue((boolean)(newValue instanceof Enumerator));
                    cc.append(SetCommand.create((EditingDomain)domain, (Object)keyStyle, (Object)NattablestylePackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)((Enumerator)newValue).getName()));
                }
            }
            return cc;
        }
    }
}

