/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.NodeSnapHelper;
import org.eclipse.papyrus.uml.diagram.common.locator.ISideAffixedNodeBorderItemLocator;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class SideAffixedNodesCreationEditPolicy
extends DefaultCreationEditPolicy {
    protected ICommand getSetBoundsCommand(CreateViewRequest request, CreateViewRequest.ViewDescriptor descriptor) {
        SetBoundsCommand setBoundsCommand = null;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Point parentLoc = this.getHostFigure().getBounds().getLocation().getCopy();
        Map params = request.getExtendedData();
        Point realLocation = (Point)params.get("initialMouseLocationForCreation");
        Point realWantedLocation = realLocation != null ? realLocation.getCopy() : request.getLocation().getCopy();
        Point requestedLocation = realWantedLocation.getCopy();
        this.getHostFigure().translateToRelative((Translatable)requestedLocation);
        ISideAffixedNodeBorderItemLocator locator = this.getPositionLocator();
        if (locator == null) {
            return null;
        }
        Rectangle preferredBounds = locator.getPreferredLocation(new Rectangle(requestedLocation, new Dimension(-1, -1)));
        Rectangle retainedBounds = preferredBounds.getCopy();
        Rectangle parentBounds = this.getHostFigure().getBounds().getCopy();
        locator.setConstraint(preferredBounds.getCopy().translate(parentBounds.getLocation().getNegated()));
        int currentSide = locator.getCurrentSideOfParent();
        if (request.isSnapToEnabled() && currentSide != 17 && currentSide != 9 && currentSide != 20 && currentSide != 12) {
            Point wantedPoint = preferredBounds.getLocation();
            this.getHostFigure().translateToAbsolute((Translatable)wantedPoint);
            Rectangle portBounds = new Rectangle(wantedPoint, new Dimension(-1, -1));
            NodeSnapHelper helper = new NodeSnapHelper((SnapToHelper)this.getHost().getAdapter(SnapToHelper.class), portBounds, false, false, true);
            ChangeBoundsRequest tmpRequest = new ChangeBoundsRequest((Object)"move");
            tmpRequest.setEditParts(Collections.emptyList());
            tmpRequest.setSnapToEnabled(true);
            tmpRequest.setLocation(portBounds.getLocation());
            helper.snapPoint(tmpRequest);
            preferredBounds.translate(tmpRequest.getMoveDelta());
            switch (currentSide) {
                case 1: 
                case 4: {
                    preferredBounds.y = retainedBounds.y;
                    break;
                }
                case 8: 
                case 16: {
                    preferredBounds.x = retainedBounds.x;
                    break;
                }
            }
        }
        Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
        setBoundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)descriptor, creationBounds);
        return setBoundsCommand;
    }

    protected ISideAffixedNodeBorderItemLocator getPositionLocator() {
        return new PortPositionLocator(this.getHostFigure(), 0);
    }

    protected IFigure getHostFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }
}

