/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForSelection;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLSelectionTester
extends PropertyTester {
    public static final String IS_UML_MODEL = "isUMLModel";
    public static final String IS_UML_PROFILE = "isUMLProfile";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor == null) {
            return false;
        }
        Boolean currentValue = null;
        if (IS_UML_MODEL.equals(property)) {
            currentValue = this.testUMLModelNature(receiver);
            return currentValue == expectedValue;
        }
        if (IS_UML_PROFILE.equals(property)) {
            currentValue = this.testUMLProfileNature(receiver);
            return currentValue == expectedValue;
        }
        return false;
    }

    protected boolean testUMLModelNature(Object receiver) {
        EObject root = this.getRoot(receiver);
        return root instanceof Package && !(root instanceof Profile);
    }

    protected boolean testUMLProfileNature(Object receiver) {
        return this.getRoot(receiver) instanceof Profile;
    }

    private EObject getRoot(Object receiver) {
        if (receiver instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)receiver;
            try {
                ModelSet modelSet = ServiceUtilsForSelection.getInstance().getModelSet((Object)selection);
                EObject root = this.getRoot(modelSet);
                return root;
            }
            catch (ServiceException ex) {
                return null;
            }
        }
        return null;
    }

    private EObject getRoot(ModelSet modelSet) {
        UmlModel openedModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        if (openedModel != null) {
            EObject root;
            try {
                root = openedModel.lookupRoot();
            }
            catch (NotFoundException e) {
                return null;
            }
            return root;
        }
        return null;
    }
}

