/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.ICustomDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.ui.PlatformUI;

public class DirectEditNodeEditPart {
    ConnectionNodeEditPart gep;
    private DirectEditManager manager;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;
    protected IParser parser;

    public DirectEditNodeEditPart(ConnectionNodeEditPart gep) {
        this.gep = gep;
    }

    public void performDirectEditRequest(Request request) {
        Request theRequest = request;
        this.updateExtendedEditorConfiguration();
        if (this.configuration == null || this.configuration.getLanguage() == null) {
            this.performDefaultDirectEditorEdit(theRequest);
        } else {
            this.configuration.preEditAction((Object)this.gep.resolveSemanticElement());
            Dialog dialog = null;
            if (this.configuration instanceof ICustomDirectEditorConfiguration) {
                this.setManager(((ICustomDirectEditorConfiguration)this.configuration).createDirectEditManager((ITextAwareEditPart)this.gep));
                this.setParser(((ICustomDirectEditorConfiguration)this.configuration).createParser(this.gep.resolveSemanticElement()));
                this.initializeDirectEditManager(theRequest);
                return;
            }
            if (this.configuration instanceof IPopupEditorConfiguration) {
                IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                helper.showEditor();
                return;
            }
            if (this.configuration instanceof IAdvancedEditorConfiguration) {
                dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.gep.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.gep.resolveSemanticElement()));
            } else if (this.configuration instanceof IDirectEditorConfiguration) {
                dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.gep.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.gep.resolveSemanticElement()), this.configuration);
            } else {
                return;
            }
            final Dialog finalDialog = dialog;
            if (dialog.open() == 0) {
                TransactionalEditingDomain domain = this.gep.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        DirectEditNodeEditPart.this.configuration.postEditAction((Object)DirectEditNodeEditPart.this.gep.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
            }
        }
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected DirectEditManager getManager() {
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void updateExtendedEditorConfiguration() {
        String id = this.gep.resolveSemanticElement().eClass().getInstanceClassName();
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + id);
        if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        } else if (this.configuration == null) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)id);
        } else if (languagePreferred != null && !languagePreferred.equals("") && !languagePreferred.equals(this.configuration.getLanguage())) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)id);
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    public IParser getParser() {
        if (this.gep instanceof ITextAwareEditPart) {
            return ((ITextAwareEditPart)this.gep).getParser();
        }
        return null;
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.gep.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (DirectEditNodeEditPart.this.gep.isActive() && DirectEditNodeEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            DirectEditNodeEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && DirectEditNodeEditPart.this.getEditText().equals(DirectEditNodeEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            DirectEditNodeEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            DirectEditNodeEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected EObject getParserElement() {
        return this.gep.resolveSemanticElement();
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public void setParser(IParser parser) {
        this.parser = parser;
    }

    protected void initializeDirectEditManager(final Request request) {
        try {
            this.gep.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (DirectEditNodeEditPart.this.gep.isActive() && DirectEditNodeEditPart.this.isEditable()) {
                        if (request.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)request.getExtendedData().get("directedit_extendeddata_initial_char");
                            DirectEditNodeEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (request instanceof DirectEditRequest && DirectEditNodeEditPart.this.getEditText().equals(DirectEditNodeEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)request;
                            DirectEditNodeEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            DirectEditNodeEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.gep.resolveSemanticElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        return text;
    }
}

