/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.IPageUtils;
import org.eclipse.papyrus.infra.core.sasheditor.editor.DefaultPageLifeCycleEventListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IComponentPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IEditorPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageLifeCycleEventsListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.PageRemovalValidator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.editor.welcome.IWelcomePageService;
import org.eclipse.papyrus.infra.editor.welcome.Welcome;
import org.eclipse.papyrus.infra.editor.welcome.WelcomePackage;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomeModelManager;
import org.eclipse.papyrus.infra.editor.welcome.internal.WelcomePage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleManager;
import org.eclipse.swt.widgets.Display;

public class WelcomePageService
implements IWelcomePageService {
    private ServicesRegistry services;
    private ModelSet modelSet;
    private ISashWindowsContainer sashContainer;
    private IPageManager pageManager;
    private EditorLifecycleManager editorManager;
    private WelcomeModelManager welcomeManager;
    private IPageLifeCycleEventsListener sashListener;
    private EditorLifecycleEventListener editorListener;
    private IPage welcomePage;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.services = servicesRegistry;
    }

    @Override
    public final ServicesRegistry getOwner() {
        return this.services;
    }

    public void startService() throws ServiceException {
        this.welcomeManager = Activator.getDefault().getWelcomeModelManager();
        this.modelSet = (ModelSet)this.services.getService(ModelSet.class);
        this.welcomeManager.connect(this.modelSet);
        this.welcomeManager.onWelcomeChanged(this.modelSet, this::handleWelcomeChanged);
        this.pageManager = (IPageManager)this.services.getService(IPageManager.class);
        this.editorManager = (EditorLifecycleManager)this.services.getService(EditorLifecycleManager.class);
        this.editorListener = new EditorListener();
        this.editorManager.addEditorLifecycleEventsListener(this.editorListener);
        this.installPageRemovalValidator();
    }

    public void disposeService() throws ServiceException {
        this.uninstallPageRemovalValidator();
        if (this.welcomeManager != null) {
            this.welcomeManager.disconnect(this.modelSet);
            this.welcomeManager = null;
        }
        this.modelSet = null;
        this.pageManager = null;
        if (this.editorManager != null) {
            this.editorManager.removeEditorLifecycleEventsListener(this.editorListener);
            this.editorManager = null;
        }
    }

    @Override
    public boolean canCloseWelcomePage() {
        return this.welcomePage != null && this.getOpenPageCount() > 1;
    }

    public int getOpenPageCount() {
        class PageCounter
        implements IPageVisitor {
            int count = 0;

            PageCounter() {
            }

            public void accept(IEditorPage page) {
                ++this.count;
            }

            public void accept(IComponentPage page) {
                ++this.count;
            }
        }
        PageCounter counter = new PageCounter();
        this.sashContainer.visit((IPageVisitor)counter);
        return counter.count;
    }

    @Override
    public void openWelcomePage() {
        if (this.pageManager != null) {
            if (this.welcomePage == null) {
                this.pageManager.openPage(this.getModel());
            } else {
                this.pageManager.selectPage(this.getModel());
            }
        }
    }

    @Override
    public void resetWelcomePage() {
        this.getWelcomePage().ifPresent(WelcomePage::reset);
    }

    Optional<WelcomePage> getWelcomePage() {
        return Optional.ofNullable((WelcomePage)PlatformHelper.getAdapter((Object)this.welcomePage, WelcomePage.class));
    }

    @Override
    public void saveWelcomePageAsDefault() throws CoreException {
        try {
            this.welcomeManager.createDefaultWelcomeResource(this.getWelcome());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.editor.welcome", "Failed to set default welcome page", (Throwable)e));
        }
    }

    void handleWelcomeChanged(Welcome welcome) {
        this.getWelcomePage().ifPresent(WelcomePage::layout);
    }

    void checkWelcomePage() {
        Display.getDefault().asyncExec(() -> {
            if (this.sashContainer != null && !this.sashContainer.isDisposed()) {
                if (this.getOpenPageCount() <= 0) {
                    this.openWelcomePage();
                }
                this.getWelcomePage().ifPresent(WelcomePage::fireCanCloseChanged);
            }
        });
    }

    @Override
    public Welcome getWelcome() {
        Welcome override = this.getWelcomeOverride();
        return override != null ? override : this.welcomeManager.getWelcome((ResourceSet)this.modelSet);
    }

    @Override
    public Resource getWelcomeResource() {
        Welcome override = this.getWelcomeOverride();
        return override != null ? override.eResource() : this.welcomeManager.getWelcomeResource((ResourceSet)this.modelSet);
    }

    private Welcome getWelcomeOverride() {
        Resource sashResource = SashModelUtils.getSashModel((ModelSet)this.modelSet).getResource();
        return sashResource == null ? null : (Welcome)EcoreUtil.getObjectByType((Collection)sashResource.getContents(), (EClassifier)WelcomePackage.Literals.WELCOME);
    }

    Object getModel() {
        return this.getWelcome();
    }

    static boolean isModel(Object object) {
        return object instanceof Welcome;
    }

    boolean isWelcomePage(IPage page) {
        return WelcomePageService.isModel(IPageUtils.getRawModel((IPage)page));
    }

    void trackActivePage(PageRef pageRef) {
        SashModel sashModel;
        TabFolder folder = pageRef.getParent();
        if (folder != null && folder.getCurrentSelection() != pageRef && (sashModel = (SashModel)EMFHelper.getContainer((EObject)folder, SashModel.class)) != null && sashModel.isRestoreActivePage()) {
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)sashModel);
            try {
                TransactionHelper.run((EditingDomain)domain, () -> folder.setCurrentSelection(pageRef));
            }
            catch (Exception e) {
                Activator.log.error("Failed to track page selection", (Throwable)e);
            }
        }
    }

    void initializeActivePages() {
        SashModel sashModel = this.getSashModel();
        if (sashModel != null && sashModel.isRestoreActivePage()) {
            this.sashContainer.getIFolderList().stream().filter(f -> f.getRawModel() instanceof TabFolder).forEach(f -> {
                IPage page;
                TabFolder tabFolder = (TabFolder)f.getRawModel();
                if (tabFolder.getCurrentSelection() != null && (page = this.sashContainer.lookupModelPage((Object)tabFolder.getCurrentSelection())) != null) {
                    this.sashContainer.selectPage(page);
                }
            });
        }
    }

    private SashModel getSashModel() {
        SashWindowsMngr sashMngr = this.modelSet == null ? null : SashModelUtils.getSashWindowsMngr((ModelSet)this.modelSet);
        return sashMngr == null ? null : sashMngr.getSashModel();
    }

    private void installPageRemovalValidator() {
        SashModel sashModel = this.getSashModel();
        if (sashModel != null) {
            sashModel.eAdapters().add((Object)new CloseValidator());
        }
    }

    private void uninstallPageRemovalValidator() {
        SashModel sashModel = this.getSashModel();
        if (sashModel != null) {
            sashModel.eAdapters().removeIf(CloseValidator.class::isInstance);
        }
    }

    private class CloseValidator
    extends AdapterImpl
    implements PageRemovalValidator {
        private SashModel sashModel;

        private CloseValidator() {
        }

        public void setTarget(Notifier newTarget) {
            if (newTarget instanceof SashModel) {
                this.sashModel = (SashModel)newTarget;
            }
        }

        public void unsetTarget(Notifier oldTarget) {
            if (oldTarget == this.sashModel) {
                this.sashModel = null;
            }
        }

        public boolean canRemovePage(PageRef page) {
            Object pageIdentifier = page.getPageIdentifier();
            return pageIdentifier != WelcomePageService.this.getModel() || WelcomePageService.this.canCloseWelcomePage();
        }

        public Collection<? extends PageRef> filterRemovablePages(Collection<? extends PageRef> pages) {
            Collection<? extends PageRef> result;
            Optional<PageRef> welcomePage = pages.stream().filter(p -> p.getPageIdentifier() == WelcomePageService.this.getModel()).findAny();
            if (!welcomePage.isPresent()) {
                result = pages;
            } else {
                long allPagesCount = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.sashModel.eAllContents(), 16), false).filter(PageRef.class::isInstance).count();
                if (allPagesCount > (long)pages.size()) {
                    result = pages;
                } else {
                    result = new ArrayList<PageRef>(pages);
                    result.remove(welcomePage.get());
                }
            }
            return result;
        }
    }

    private class EditorListener
    implements EditorLifecycleEventListener {
        private EditorListener() {
        }

        public void postInit(IMultiDiagramEditor editor) {
        }

        public void preDisplay(IMultiDiagramEditor editor) {
            WelcomePageService.this.sashContainer = (ISashWindowsContainer)editor.getAdapter(ISashWindowsContainer.class);
            WelcomePageService.this.sashListener = (IPageLifeCycleEventsListener)new SashListener();
            WelcomePageService.this.sashContainer.addPageLifeCycleListener(WelcomePageService.this.sashListener);
            WelcomePageService.this.welcomePage = IPageUtils.lookupModelPage((ISashWindowsContainer)WelcomePageService.this.sashContainer, (Object)WelcomePageService.this.getModel());
            if (WelcomePageService.this.welcomePage == null) {
                WelcomePageService.this.welcomePage = IPageUtils.lookupModelPage((ISashWindowsContainer)WelcomePageService.this.sashContainer, (Object)WelcomePageService.this.welcomeManager.getWelcome((ResourceSet)WelcomePageService.this.modelSet));
            }
            WelcomePageService.this.checkWelcomePage();
            WelcomePageService.this.initializeActivePages();
        }

        public void postDisplay(IMultiDiagramEditor editor) {
        }

        public void beforeClose(IMultiDiagramEditor editor) {
            WelcomePageService.this.sashListener = null;
        }
    }

    private class SashListener
    extends DefaultPageLifeCycleEventListener {
        private SashListener() {
        }

        public void pageOpened(IPage page) {
            if (WelcomePageService.this.isWelcomePage(page)) {
                WelcomePageService.this.welcomePage = page;
            }
            WelcomePageService.this.checkWelcomePage();
        }

        public void pageClosed(IPage page) {
            if (page == WelcomePageService.this.welcomePage) {
                WelcomePageService.this.welcomePage = null;
            }
            WelcomePageService.this.checkWelcomePage();
        }

        public void pageActivated(IPage page) {
            if (page.getRawModel() instanceof PageRef) {
                PageRef pageRef = (PageRef)page.getRawModel();
                WelcomePageService.this.trackActivePage(pageRef);
            }
        }
    }
}

