/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class QvtCompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;

    public QvtCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public QvtCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public void setDisplayString(String displayString) {
        this.fDisplayString = displayString;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        this.fReplacementLength = replacementLength;
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.fCursorPosition = cursorPosition;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
    }

    public void setAdditionalProposalInfo(String additionalProposalInfo) {
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QvtCompletionProposal)) {
            return false;
        }
        QvtCompletionProposal proposal = (QvtCompletionProposal)obj;
        if (this == proposal) {
            return true;
        }
        if (this.fReplacementString == null) {
            return super.equals(obj);
        }
        return this.fReplacementString.equals(proposal.fReplacementString) && this.fDisplayString.equals(proposal.fDisplayString) && QvtCompletionProposal.areEqual(this.fImage, proposal.fImage) && QvtCompletionProposal.areEqual(this.fAdditionalProposalInfo, proposal.fAdditionalProposalInfo);
    }

    public int hashCode() {
        if (this.fReplacementString == null) {
            return super.hashCode();
        }
        int[] elementaryHashCodes = new int[]{this.fReplacementString.hashCode(), this.fDisplayString.hashCode(), QvtCompletionProposal.hashCodeInternal(this.fImage), QvtCompletionProposal.hashCodeInternal(this.fAdditionalProposalInfo)};
        int hash = 17;
        int[] nArray = elementaryHashCodes;
        int n = elementaryHashCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            hash += 31 * i;
            ++n2;
        }
        return hash;
    }

    private static boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static int hashCodeInternal(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }
}

