/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class VButtonImageBak {
    private static VButtonImageBak instance;
    private Map<String, ImageData> images = new HashMap<String, ImageData>();
    private Map<ImageData, String> keys = new HashMap<ImageData, String>();
    private Map<String, List<VButton>> requests = new HashMap<String, List<VButton>>();
    private Map<ImageData, Set<VButton>> buttons = new HashMap<ImageData, Set<VButton>>();

    private static String getKey(VButton button) {
        StringBuilder sb = new StringBuilder();
        sb.append(button.getState());
        sb.append(button == VTracker.getFocusControl());
        sb.append(":");
        sb.append(button.bounds.width);
        sb.append(":");
        sb.append(button.bounds.height);
        return sb.toString();
    }

    public static VButtonImageBak instance() {
        if (instance == null) {
            instance = new VButtonImageBak();
        }
        return instance;
    }

    private VButtonImageBak() {
    }

    private void createImage(VButton button) {
        String key = VButtonImageBak.getKey(button);
        if (this.requests.containsKey(key)) {
            this.requests.get(key).add(button);
        } else {
            this.requests.put(key, new ArrayList());
            this.requests.get(key).add(button);
            int style = button.getStyle() & 0x30;
            if (style == 0) {
                style = 2;
            }
            Button b = new Button(button.composite, style);
            b.setBackground(button.getBackground());
            b.setBounds(button.getBounds());
            if (button.hasState(4)) {
                b.setSelection(true);
            }
            if (button == VTracker.getFocusControl()) {
                b.setFocus();
            }
            b.addListener(9, (Listener)new ImageListener(key, b));
            b.redraw();
            b.update();
        }
    }

    public ImageData getImageData(VButton button) {
        if (!button.bounds.isEmpty()) {
            String key = VButtonImageBak.getKey(button);
            ImageData data = this.images.get(key);
            if (data == null) {
                this.createImage(button);
            } else {
                if (this.partialImage(key, data)) {
                    this.images.remove(key);
                    this.keys.remove(data);
                } else {
                    if (button.oldImageData != null && button.oldImageData != data) {
                        this.removeUnusedData();
                    }
                    if (!this.buttons.containsKey(data)) {
                        this.buttons.put(data, new HashSet());
                    }
                    if (!this.buttons.get(data).contains(button)) {
                        this.buttons.get(data).add(button);
                    }
                }
                return data;
            }
        }
        return null;
    }

    private boolean partialImage(String key, ImageData data) {
        String[] sa = key.split(":");
        int w = Integer.parseInt(sa[1]);
        int h = Integer.parseInt(sa[2]);
        return data.height != h || data.width != w;
    }

    void removeUnusedData() {
        Iterator<ImageData> i1 = this.buttons.keySet().iterator();
        while (i1.hasNext()) {
            ImageData data = i1.next();
            Iterator<VButton> i2 = this.buttons.get(data).iterator();
            while (i2.hasNext()) {
                Point size = i2.next().getSize();
                if (size.x == data.width && size.y == data.height) continue;
                i2.remove();
            }
            if (!this.buttons.get(data).isEmpty()) continue;
            this.images.remove(this.keys.get(data));
            this.keys.remove(data);
            i1.remove();
        }
    }

    private class ImageListener
    implements Listener {
        private String key;
        private Button b;

        ImageListener(String key, Button b) {
            this.key = key;
            this.b = b;
        }

        public void handleEvent(Event e) {
            GC gc = new GC((Drawable)this.b);
            Image image = new Image((Device)this.b.getDisplay(), e.width, e.height);
            gc.copyArea(image, 0, 0);
            ImageData data = image.getImageData();
            gc.dispose();
            image.dispose();
            VButtonImageBak.this.images.put(this.key, data);
            VButtonImageBak.this.keys.put(data, this.key);
            if (VButtonImageBak.this.requests.containsKey(this.key)) {
                Iterator<VButton> iter = VButtonImageBak.this.requests.get(this.key).iterator();
                while (iter.hasNext()) {
                    iter.next().redraw();
                    iter.remove();
                }
                VButtonImageBak.this.requests.remove(this.key);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ImageListener.this.b.isDisposed() && ImageListener.this.b == ImageListener.this.b.getDisplay().getFocusControl()) {
                        ImageListener.this.b.getParent().forceFocus();
                    }
                    ImageListener.this.b.dispose();
                }
            });
        }
    }
}

