/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.pde.api.tools.annotations.NoReference;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

@NoReference
public class LazyResourceManager
extends ResourceManager {
    private final ResourceManager parent;
    private final LruMap unreferenced;
    private final Map<DeviceResourceDescriptor<?>, Integer> refCount;

    public LazyResourceManager(int cacheSize, ResourceManager parent) {
        this.parent = parent;
        this.unreferenced = new LruMap(cacheSize);
        this.refCount = new HashMap();
    }

    @Override
    public Device getDevice() {
        return this.parent.getDevice();
    }

    private boolean shouldBeCached(DeviceResourceDescriptor<?> descriptor) {
        return descriptor != null && descriptor.shouldBeCached();
    }

    @Override
    protected Image getDefaultImage() {
        return this.parent.getDefaultImage();
    }

    @Override
    public <R> R create(DeviceResourceDescriptor<R> descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            return this.parent.create(descriptor);
        }
        int updatedRefs = this.refCount.compute(descriptor, (k, refs) -> refs == null ? 1 : refs + 1);
        if (updatedRefs == 1) {
            ResourceManager cached = (ResourceManager)this.unreferenced.remove(descriptor);
            if (cached == null) {
                return this.parent.create(descriptor);
            }
        } else assert (!this.unreferenced.containsKey(descriptor));
        return this.parent.find(descriptor);
    }

    @Override
    public <R> void destroy(DeviceResourceDescriptor<R> descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            this.parent.destroy(descriptor);
            return;
        }
        Integer refsLeft = this.refCount.computeIfPresent(descriptor, (k, refs) -> refs == 1 ? null : Integer.valueOf(refs - 1));
        if (refsLeft == null) {
            ResourceManager old = this.unreferenced.put(descriptor, this.parent);
            assert (old == null);
        }
    }

    @Override
    public <R> R find(DeviceResourceDescriptor<R> descriptor) {
        if (!this.shouldBeCached(descriptor)) {
            return this.parent.find(descriptor);
        }
        if (this.refCount.containsKey(descriptor)) {
            return this.parent.find(descriptor);
        }
        return null;
    }

    private static class LruMap
    extends LinkedHashMap<DeviceResourceDescriptor<?>, ResourceManager> {
        private static final long serialVersionUID = 1L;
        int cacheSize;

        LruMap(int cacheSize) {
            super(cacheSize, 0.75f, true);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<DeviceResourceDescriptor<?>, ResourceManager> eldest) {
            boolean remove;
            boolean bl = remove = this.size() > this.cacheSize;
            if (remove) {
                eldest.getValue().destroy(eldest.getKey());
            }
            return remove;
        }
    }
}

