/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.p2.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.util.IOUtil;

public class MarketPlaceListing {
    private static final String MARKET_PLACE_ANNOTATION = "https://marketplace.eclipse.org";
    private static final Pattern MARKET_PLACE_CONTENT_PATTERN = Pattern.compile("(https?://marketplace\\.eclipse\\.org/content/[^/?#]*+)");
    private static final Pattern MARKET_PLACE_INSTALL_PATTERN = Pattern.compile("https?://marketplace\\.eclipse\\.org/marketplace-client-intro\\?mpc_install=([0-9]+)");
    private static final Pattern IU_PATTERN = Pattern.compile(" *<iu( ?[^>]*)>([^<]+)</iu>");
    private static final Pattern UPDATE_URL_PATTERN = Pattern.compile(" *<updateurl>([^<]+)</updateurl>");
    private static final Pattern NODE_PATTERN = Pattern.compile(" *<node.*name=\"([^\"]*)\".*url=\"([^\"]*)\".*>");
    private static final Map<URI, MarketPlaceListing> MARKET_PLACE_LISTINGS = Collections.synchronizedMap(new WeakHashMap());
    private final String label;
    private final URI updateSite;
    private final URI listing;
    private final IOException exception;
    private final List<Requirement> requirements;

    private MarketPlaceListing(URI uri, URIConverter uriConverter) {
        IOException exception;
        String label;
        URI listing;
        URI updateSite;
        block12: {
            this.requirements = new ArrayList<Requirement>();
            updateSite = null;
            listing = null;
            label = uri.toString();
            InputStream inputStream = null;
            exception = null;
            try {
                try {
                    inputStream = uriConverter.createInputStream(uri);
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    if (!lines.contains("<marketplace>")) {
                        throw new IOException("Missing market place entry: " + (lines.isEmpty() ? "<no-content>" : (String)lines.get(0)));
                    }
                    for (String line : lines) {
                        Matcher nodeMatcher;
                        Matcher updateURLMatcher;
                        Matcher iuMatcher = IU_PATTERN.matcher(line);
                        if (iuMatcher.matches()) {
                            String iu = iuMatcher.group(2);
                            Requirement requirement = P2Factory.eINSTANCE.createRequirement((String)(iu.endsWith(".feature.group") ? iu : iu + ".feature.group"));
                            this.requirements.add(requirement);
                            String attributes = iuMatcher.group(1);
                            if (attributes.contains("required=\"TRUE\"")) {
                                MarketPlaceListing.setRequired(requirement);
                            }
                            if (attributes.contains("selected=\"TRUE\"")) {
                                MarketPlaceListing.setSelected(requirement);
                            }
                        }
                        if ((updateURLMatcher = UPDATE_URL_PATTERN.matcher(line)).matches()) {
                            updateSite = URI.createURI((String)updateURLMatcher.group(1));
                        }
                        if (!(nodeMatcher = NODE_PATTERN.matcher(line)).matches()) continue;
                        label = nodeMatcher.group(1);
                        Object listingValue = nodeMatcher.group(2);
                        if (((String)listingValue).startsWith("http:")) {
                            listingValue = "https:" + ((String)listingValue).substring("http:".length());
                        }
                        listing = URI.createURI((String)listingValue);
                    }
                }
                catch (IOException ex) {
                    exception = ex;
                    listing = uri;
                    IOUtil.closeSilent((Closeable)inputStream);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
        this.updateSite = updateSite;
        this.listing = listing;
        this.label = label;
        this.exception = exception;
    }

    public IOException getException() {
        return this.exception;
    }

    public URI getUpdateSite() {
        return this.updateSite;
    }

    public URI getListing() {
        return this.listing;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Requirement> getRequirements() {
        return new ArrayList<Requirement>(EcoreUtil.copyAll(this.requirements));
    }

    public static boolean isRequired(Requirement requirement) {
        Annotation annotation = requirement.getAnnotation(MARKET_PLACE_ANNOTATION);
        return annotation != null && "true".equals(annotation.getDetails().get((Object)"required"));
    }

    private static void setRequired(Requirement requirement) {
        Annotation annotation = requirement.getAnnotation(MARKET_PLACE_ANNOTATION);
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource(MARKET_PLACE_ANNOTATION);
            requirement.getAnnotations().add((Object)annotation);
        }
        annotation.getDetails().put((Object)"required", (Object)"true");
    }

    public static boolean isSelected(Requirement requirement) {
        Annotation annotation = requirement.getAnnotation(MARKET_PLACE_ANNOTATION);
        return annotation != null && "true".equals(annotation.getDetails().get((Object)"selected"));
    }

    private static void setSelected(Requirement requirement) {
        Annotation annotation = requirement.getAnnotation(MARKET_PLACE_ANNOTATION);
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource(MARKET_PLACE_ANNOTATION);
            requirement.getAnnotations().add((Object)annotation);
        }
        annotation.getDetails().put((Object)"selected", (Object)"true");
    }

    public static boolean isMarketPlaceListing(URI uri) {
        return MarketPlaceListing.getMarketPlaceListingURI(uri) != null;
    }

    public static MarketPlaceListing getMarketPlaceListing(URI uri, URIConverter uriConverter) {
        URI marketPlaceListingURI;
        MarketPlaceListing marketPlaceListing = MARKET_PLACE_LISTINGS.get(uri);
        if (marketPlaceListing == null && (marketPlaceListingURI = MarketPlaceListing.getMarketPlaceListingURI(uri)) != null && (marketPlaceListing = MARKET_PLACE_LISTINGS.get(marketPlaceListingURI)) == null) {
            marketPlaceListing = new MarketPlaceListing(marketPlaceListingURI, uriConverter);
            MARKET_PLACE_LISTINGS.put(uri, marketPlaceListing);
            MARKET_PLACE_LISTINGS.put(marketPlaceListingURI, marketPlaceListing);
            MARKET_PLACE_LISTINGS.put(marketPlaceListing.getListing(), marketPlaceListing);
        }
        return marketPlaceListing;
    }

    public static void flush() {
        MARKET_PLACE_LISTINGS.clear();
    }

    private static URI getMarketPlaceListingURI(URI uri) {
        String uriLiteral = uri.toString();
        Matcher matcher = MARKET_PLACE_CONTENT_PATTERN.matcher(uriLiteral);
        if (matcher.matches()) {
            return URI.createURI((String)(matcher.group(1) + "/api/p"));
        }
        matcher = MARKET_PLACE_INSTALL_PATTERN.matcher(uriLiteral);
        if (matcher.matches()) {
            String listing2 = matcher.group(1);
            return URI.createURI((String)("https://marketplace.eclipse.org/node/" + listing2 + "/api/p"));
        }
        return null;
    }
}

