/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.keys.IBindingService;

public abstract class QuickMenuAction
extends Action {
    private QuickMenuCreator creator = new QuickMenuCreator(){

        protected void fillMenu(IMenuManager menu) {
            QuickMenuAction.this.fillMenu(menu);
        }
    };

    public QuickMenuAction(String commandId) {
        this.setId(commandId);
        this.setActionDefinitionId(commandId);
    }

    public void run() {
        this.creator.createMenu();
    }

    public void dispose() {
        if (this.creator != null) {
            this.creator = null;
        }
    }

    protected abstract void fillMenu(IMenuManager var1);

    public String getShortCutString() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IBindingService bindingService = (IBindingService)Adapters.adapt((Object)workbench, IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor(this.getActionDefinitionId());
        if (activeBindings.length > 0) {
            return activeBindings[0].format();
        }
        return null;
    }
}

