/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgStyle;
import org.eclipse.nebula.cwt.svg.SvgTransform;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SvgFragment
extends SvgContainer {
    Float x;
    Float y;
    Float width;
    Float height;
    float[] viewBox;
    SvgTransform boundsTransform;
    boolean preserveAspectRatio;
    private Map<String, SvgElement> elementMap = new HashMap<String, SvgElement>();

    SvgFragment(SvgContainer container, String id) {
        super(container, id);
        this.boundsTransform = new SvgTransform();
        this.boundsTransform.data = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }

    public void apply(GC gc, Rectangle bounds) {
        this.boundsTransform.translate(bounds.x, bounds.y);
        if (this.viewBox != null) {
            float sx = (float)bounds.width / this.viewBox[2];
            float sy = (float)bounds.height / this.viewBox[3];
            this.boundsTransform.scale(sx, sy);
        } else if (this.width != null && this.height != null) {
            float sx = (float)bounds.width / this.width.floatValue();
            float sy = (float)bounds.height / this.height.floatValue();
            this.boundsTransform.scale(sx, sy);
        }
        super.apply(gc);
        this.boundsTransform.data = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    }

    @Override
    public SvgElement getElement(String id) {
        return this.elementMap.get(id);
    }

    @Override
    public SvgFragment getFragment() {
        return this;
    }

    public Map<String, String> getStyles(String className) {
        Map<String, Map<String, String>> classes;
        SvgElement element = this.elementMap.get("style");
        if (element instanceof SvgStyle && (classes = ((SvgStyle)element).styles) != null) {
            return classes.get(className);
        }
        return null;
    }

    @Override
    public float[] getViewport() {
        if (this.x == null || this.y == null) {
            return new float[]{0.0f, 0.0f, this.width.floatValue(), this.height.floatValue()};
        }
        return new float[]{this.x.floatValue(), this.y.floatValue(), this.width.floatValue(), this.height.floatValue()};
    }

    public boolean hasElement(String id) {
        return this.elementMap.containsKey(id);
    }

    public boolean isOutermost() {
        return this.getContainer() == null;
    }

    void put(SvgElement element) {
        String id = element.getId();
        if (id != null) {
            this.elementMap.put(id, element);
        }
    }

    public float[] getViewBox() {
        return this.viewBox;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }
}

