/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.AbstractResourceManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public final class DeviceResourceManager
extends AbstractResourceManager {
    private final Device device;
    private Image missingImage;

    @Override
    public Device getDevice() {
        return this.device;
    }

    public DeviceResourceManager(Device device) {
        this.device = device;
    }

    @Override
    protected <R> R allocate(DeviceResourceDescriptor<R> descriptor) throws DeviceResourceException {
        return (R)descriptor.createResource(this.device);
    }

    @Override
    protected <R> void deallocate(Object resource, DeviceResourceDescriptor<R> descriptor) {
        descriptor.destroyResource(resource);
    }

    @Override
    protected Image getDefaultImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.missingImage != null) {
            this.missingImage.dispose();
            this.missingImage = null;
        }
    }
}

