/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.printing.PageSize;

public final class PDFDocument
extends Device {
    long surface;
    long cairo;
    boolean isGCCreated = false;
    String filename;
    double widthInPoints;
    double heightInPoints;

    public PDFDocument(String filename, PageSize pageSize) {
        super(PDFDocument.checkData(filename, pageSize));
    }

    public PDFDocument(String filename, double widthInPoints, double heightInPoints) {
        this(filename, new PageSize(widthInPoints, heightInPoints));
    }

    static PDFDocumentData checkData(String filename, PageSize pageSize) {
        if (pageSize == null) {
            SWT.error(4);
        }
        return PDFDocument.checkData(filename, pageSize.width(), pageSize.height());
    }

    static PDFDocumentData checkData(String filename, double widthInPoints, double heightInPoints) {
        if (filename == null) {
            SWT.error(4);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        PDFDocumentData data = new PDFDocumentData();
        data.filename = filename;
        data.widthInPoints = widthInPoints;
        data.heightInPoints = heightInPoints;
        return data;
    }

    @Override
    protected void create(DeviceData data) {
        PDFDocumentData pdfData = (PDFDocumentData)data;
        this.filename = pdfData.filename;
        this.widthInPoints = pdfData.widthInPoints;
        this.heightInPoints = pdfData.heightInPoints;
        byte[] filenameBytes = Converter.wcsToMbcs(this.filename, true);
        this.surface = Cairo.cairo_pdf_surface_create(filenameBytes, this.widthInPoints, this.heightInPoints);
        if (this.surface == 0L) {
            SWT.error(2);
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0L) {
            Cairo.cairo_surface_destroy(this.surface);
            this.surface = 0L;
            SWT.error(2);
        }
    }

    public void newPage() {
        this.checkDevice();
        Cairo.cairo_show_page(this.cairo);
    }

    public void newPage(double widthInPoints, double heightInPoints) {
        this.checkDevice();
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        Cairo.cairo_show_page(this.cairo);
        Cairo.cairo_pdf_surface_set_size(this.surface, widthInPoints, heightInPoints);
        this.widthInPoints = widthInPoints;
        this.heightInPoints = heightInPoints;
    }

    public double getWidth() {
        this.checkDevice();
        return this.widthInPoints;
    }

    public double getHeight() {
        this.checkDevice();
        return this.heightInPoints;
    }

    @Override
    public Point getDPI() {
        this.checkDevice();
        return new Point(72, 72);
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, (int)this.widthInPoints, (int)this.heightInPoints);
    }

    @Override
    public long internal_new_GC(GCData data) {
        this.checkDevice();
        if (this.isGCCreated) {
            SWT.error(5);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.cairo = this.cairo;
            data.width = (int)this.widthInPoints;
            data.height = (int)this.heightInPoints;
            data.foregroundRGBA = this.getSystemColor((int)2).handle;
            data.backgroundRGBA = this.getSystemColor((int)1).handle;
            data.font = this.getSystemFont();
        }
        this.isGCCreated = true;
        return this.cairo;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    @Override
    protected void destroy() {
        if (this.cairo != 0L) {
            Cairo.cairo_destroy(this.cairo);
            this.cairo = 0L;
        }
        if (this.surface != 0L) {
            Cairo.cairo_surface_finish(this.surface);
            Cairo.cairo_surface_destroy(this.surface);
            this.surface = 0L;
        }
    }

    static class PDFDocumentData
    extends DeviceData {
        String filename;
        double widthInPoints;
        double heightInPoints;

        PDFDocumentData() {
        }
    }
}

