/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DEVMODE;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PageSize;

public final class PDFDocument
extends Device {
    long handle;
    boolean isGCCreated = false;
    boolean jobStarted = false;
    boolean pageStarted = false;
    String filename;
    double preferredWidthInPoints;
    double preferredHeightInPoints;
    double actualWidthInPoints;
    double actualHeightInPoints;
    private static final String PDF_PRINTER_NAME = "Microsoft Print to PDF";
    private static final double POINTS_PER_INCH = 72.0;

    private static PaperSize findBestPaperSize(double widthInPoints, double heightInPoints) {
        int[][] standardSizes = new int[][]{{1, 612, 792}, {5, 612, 1008}, {9, 595, 842}, {3, 792, 1224}, {8, 842, 1191}, {7, 522, 756}, {11, 420, 595}};
        PaperSize bestMatch = null;
        double minWaste = Double.MAX_VALUE;
        int[][] nArrayArray = standardSizes;
        int n = standardSizes.length;
        int n2 = 0;
        while (n2 < n) {
            double waste;
            int[] size = nArrayArray[n2];
            double paperWidth = size[1];
            double paperHeight = size[2];
            if (widthInPoints <= paperWidth && heightInPoints <= paperHeight && (waste = paperWidth * paperHeight - widthInPoints * heightInPoints) < minWaste) {
                minWaste = waste;
                bestMatch = new PaperSize(size[0], 1, paperWidth, paperHeight);
            }
            if (widthInPoints <= paperHeight && heightInPoints <= paperWidth && (waste = paperHeight * paperWidth - widthInPoints * heightInPoints) < minWaste) {
                minWaste = waste;
                bestMatch = new PaperSize(size[0], 2, paperHeight, paperWidth);
            }
            ++n2;
        }
        if (bestMatch == null) {
            SWT.error(5, null, " [Requested page size exceeds maximum supported size]");
        }
        return bestMatch;
    }

    public PDFDocument(String filename, PageSize pageSize) {
        super(PDFDocument.checkData(filename, pageSize));
    }

    public PDFDocument(String filename, double widthInPoints, double heightInPoints) {
        this(filename, new PageSize(widthInPoints, heightInPoints));
    }

    static PDFDocumentData checkData(String filename, PageSize pageSize) {
        if (pageSize == null) {
            SWT.error(4);
        }
        return PDFDocument.checkData(filename, pageSize.width(), pageSize.height());
    }

    static PDFDocumentData checkData(String filename, double widthInPoints, double heightInPoints) {
        if (filename == null) {
            SWT.error(4);
        }
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        PDFDocumentData data = new PDFDocumentData();
        data.filename = filename;
        data.widthInPoints = widthInPoints;
        data.heightInPoints = heightInPoints;
        return data;
    }

    @Override
    protected void create(DeviceData data) {
        PDFDocumentData pdfData = (PDFDocumentData)data;
        this.filename = pdfData.filename;
        this.preferredWidthInPoints = pdfData.widthInPoints;
        this.preferredHeightInPoints = pdfData.heightInPoints;
        PaperSize bestMatch = PDFDocument.findBestPaperSize(this.preferredWidthInPoints, this.preferredHeightInPoints);
        this.actualWidthInPoints = bestMatch.widthInPoints;
        this.actualHeightInPoints = bestMatch.heightInPoints;
        TCHAR driver = new TCHAR(0, "WINSPOOL", true);
        TCHAR deviceName = new TCHAR(0, PDF_PRINTER_NAME, true);
        long[] hPrinter = new long[1];
        if (OS.OpenPrinter(deviceName, hPrinter, 0L)) {
            long hHeap;
            long lpInitData;
            int dwNeeded = OS.DocumentProperties(0L, hPrinter[0], deviceName, 0L, 0L, 0);
            if (dwNeeded >= 0 && (lpInitData = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, dwNeeded)) != 0L) {
                int rc = OS.DocumentProperties(0L, hPrinter[0], deviceName, lpInitData, 0L, 2);
                if (rc == 1) {
                    DEVMODE devmode = new DEVMODE();
                    OS.MoveMemory(devmode, lpInitData, DEVMODE.sizeof);
                    devmode.dmPaperSize = (short)bestMatch.paperSizeConstant;
                    devmode.dmOrientation = (short)bestMatch.orientation;
                    devmode.dmFields = 3;
                    OS.MoveMemory(lpInitData, devmode, DEVMODE.sizeof);
                    this.handle = OS.CreateDC(driver, deviceName, 0L, lpInitData);
                }
                OS.HeapFree(hHeap, 0, lpInitData);
            }
            OS.ClosePrinter(hPrinter[0]);
        }
        if (this.handle == 0L) {
            SWT.error(2, null, " [Failed to create device context for 'Microsoft Print to PDF'. Ensure the printer is installed and enabled.]");
        }
    }

    private void ensureJobStarted() {
        if (!this.jobStarted) {
            DOCINFO di = new DOCINFO();
            di.cbSize = DOCINFO.sizeof;
            long hHeap = OS.GetProcessHeap();
            TCHAR buffer = new TCHAR(0, this.filename, true);
            int byteCount = buffer.length() * 2;
            long lpszOutput = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszOutput, buffer, byteCount);
            di.lpszOutput = lpszOutput;
            TCHAR docName = new TCHAR(0, "SWT PDF Document", true);
            int docByteCount = docName.length() * 2;
            long lpszDocName = OS.HeapAlloc(hHeap, 8, docByteCount);
            OS.MoveMemory(lpszDocName, docName, docByteCount);
            di.lpszDocName = lpszDocName;
            int rc = OS.StartDoc(this.handle, di);
            OS.HeapFree(hHeap, 0, lpszOutput);
            OS.HeapFree(hHeap, 0, lpszDocName);
            if (rc <= 0) {
                int lastError = OS.GetLastError();
                SWT.error(2, null, " [StartDoc failed for 'Microsoft Print to PDF' (rc=" + rc + ", lastError=" + lastError + ")]");
            }
            this.jobStarted = true;
        }
    }

    private void ensurePageStarted() {
        this.ensureJobStarted();
        if (!this.pageStarted) {
            int rc = OS.StartPage(this.handle);
            if (rc <= 0) {
                int lastError = OS.GetLastError();
                SWT.error(2, null, " [StartPage failed (rc=" + rc + ", lastError=" + lastError + ")]");
            }
            this.pageStarted = true;
        }
    }

    public void newPage() {
        this.checkDevice();
        if (this.pageStarted) {
            OS.EndPage(this.handle);
            this.pageStarted = false;
        }
        this.ensurePageStarted();
    }

    public void newPage(double widthInPoints, double heightInPoints) {
        this.checkDevice();
        if (widthInPoints <= 0.0 || heightInPoints <= 0.0) {
            SWT.error(5);
        }
        this.preferredWidthInPoints = widthInPoints;
        this.preferredHeightInPoints = heightInPoints;
        PaperSize bestMatch = PDFDocument.findBestPaperSize(widthInPoints, heightInPoints);
        this.actualWidthInPoints = bestMatch.widthInPoints;
        this.actualHeightInPoints = bestMatch.heightInPoints;
        this.newPage();
    }

    public double getWidth() {
        this.checkDevice();
        return this.actualWidthInPoints;
    }

    public double getHeight() {
        this.checkDevice();
        return this.actualHeightInPoints;
    }

    @Override
    public Point getDPI() {
        this.checkDevice();
        return new Point(72, 72);
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, (int)this.actualWidthInPoints, (int)this.actualHeightInPoints);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        int printerDpiX = OS.GetDeviceCaps(this.handle, 88);
        int printerDpiY = OS.GetDeviceCaps(this.handle, 90);
        int printableWidth = OS.GetDeviceCaps(this.handle, 8);
        int printableHeight = OS.GetDeviceCaps(this.handle, 10);
        int offsetX = OS.GetDeviceCaps(this.handle, 112);
        int offsetY = OS.GetDeviceCaps(this.handle, 113);
        double scaleX = 72.0 / (double)printerDpiX;
        double scaleY = 72.0 / (double)printerDpiY;
        int x = (int)((double)offsetX * scaleX);
        int y = (int)((double)offsetY * scaleY);
        int width = (int)((double)printableWidth * scaleX);
        int height = (int)((double)printableHeight * scaleY);
        return new Rectangle(x, y, width, height);
    }

    @Override
    public long internal_new_GC(GCData data) {
        this.checkDevice();
        if (this.handle == 0L) {
            SWT.error(2, null, " [PDF document handle is not valid]");
        }
        if (data != null) {
            if (this.isGCCreated) {
                SWT.error(5);
            }
            this.ensurePageStarted();
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.nativeZoom = 100;
            data.font = this.getSystemFont();
            int printerDpiX = OS.GetDeviceCaps(this.handle, 88);
            int printerDpiY = OS.GetDeviceCaps(this.handle, 90);
            float scaleX = (float)((double)printerDpiX / 72.0);
            float scaleY = (float)((double)printerDpiY / 72.0);
            OS.SetGraphicsMode(this.handle, 2);
            float[] transform = new float[]{scaleX, 0.0f, 0.0f, scaleY, 0.0f, 0.0f};
            OS.SetWorldTransform(this.handle, transform);
            this.isGCCreated = true;
        }
        return this.handle;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        if (data != null) {
            this.isGCCreated = false;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    @Override
    protected void destroy() {
        if (this.handle != 0L) {
            if (this.pageStarted) {
                OS.EndPage(this.handle);
            }
            if (this.jobStarted) {
                OS.EndDoc(this.handle);
            }
            OS.DeleteDC(this.handle);
            this.handle = 0L;
        }
    }

    static class PDFDocumentData
    extends DeviceData {
        String filename;
        double widthInPoints;
        double heightInPoints;

        PDFDocumentData() {
        }
    }

    private static class PaperSize {
        int paperSizeConstant;
        int orientation;
        double widthInPoints;
        double heightInPoints;

        PaperSize(int paperSize, int orientation, double width, double height) {
            this.paperSizeConstant = paperSize;
            this.orientation = orientation;
            this.widthInPoints = width;
            this.heightInPoints = height;
        }
    }
}

