/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Objects;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    long arrowHandle;
    long labelHandle;
    long imageHandle;
    long eventHandle;
    long proxyMenuItem;
    long provider;
    long boxHandle;
    long groupHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    Image defaultDisableImage;
    Color background;
    Color foreground;
    String toolTipText;
    boolean drawHotImage;
    boolean mapHooked;
    boolean enabled = true;
    Image currentImage;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        int bits = 62;
        switch (this.style & bits) {
            case 2: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_separator_new(1);
                    if (this.handle != 0L) break;
                    this.error(2);
                    break;
                }
                this.handle = GTK3.gtk_separator_tool_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_separator_tool_item_set_draw(this.handle, true);
                break;
            }
            case 4: {
                if (GTK.GTK4) {
                    long button;
                    this.handle = GTK.gtk_box_new(0, 0);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if ((button = GTK.gtk_button_new()) == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(button, this.boxHandle);
                    long menuButton = GTK.gtk_menu_button_new();
                    if (menuButton == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_box_append(this.handle, button);
                    GTK4.gtk_box_append(this.handle, menuButton);
                    this.arrowHandle = GTK4.gtk_widget_get_first_child(menuButton);
                    GTK4.gtk_menu_button_set_use_underline(menuButton, true);
                } else {
                    this.handle = GTK3.gtk_menu_tool_button_new(0L, null);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    long child = GTK3.gtk_bin_get_child(this.handle);
                    long list = GTK3.gtk_container_get_children(child);
                    this.arrowHandle = OS.g_list_nth_data(list, 1);
                    OS.g_list_free(list);
                }
                if (this.arrowHandle == 0L) break;
                GTK.gtk_widget_set_sensitive(this.arrowHandle, true);
                break;
            }
            case 16: 
            case 32: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_toggle_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(this.handle, this.boxHandle);
                    GTK.gtk_button_set_use_underline(this.handle, true);
                    break;
                }
                this.handle = GTK3.gtk_toggle_tool_button_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                if (GTK.GTK4) {
                    this.handle = GTK.gtk_button_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = GTK.gtk_box_new(1, 0);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_button_set_child(this.handle, this.boxHandle);
                    GTK.gtk_button_set_use_underline(this.handle, true);
                    break;
                }
                this.handle = GTK3.gtk_tool_button_new(0L, null);
                if (this.handle != 0L) break;
                this.error(2);
            }
        }
        if ((this.style & 2) == 0) {
            if (GTK.GTK4) {
                this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_widget_set_valign(this.boxHandle, 3);
                GTK4.gtk_box_append(this.boxHandle, this.imageHandle);
                GTK4.gtk_box_append(this.boxHandle, this.labelHandle);
                GTK.gtk_widget_hide(this.imageHandle);
                GTK.gtk_widget_hide(this.labelHandle);
            } else {
                this.labelHandle = GTK.gtk_label_new_with_mnemonic(null);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.imageHandle = GTK3.gtk_image_new_from_surface(0L);
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_tool_button_set_icon_widget(this.handle, this.imageHandle);
                GTK3.gtk_tool_button_set_label_widget(this.handle, this.labelHandle);
                GTK3.gtk_tool_button_set_use_underline(this.handle, true);
            }
        }
        if ((this.parent.state & 0x4000) != 0) {
            long fontDesc = this.parent.getFontDescription();
            this.setFontDescription(fontDesc);
            OS.pango_font_description_free(fontDesc);
        }
        if (GTK.GTK4) {
            GTK.gtk_box_set_homogeneous(this.parent.handle, false);
        } else {
            GTK3.gtk_tool_item_set_homogeneous(this.handle, false);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.eventHandle != 0L) {
            this.display.removeWidget(this.eventHandle);
        }
        if (this.arrowHandle != 0L) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    @Override
    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            height = Math.max(height, 23);
        }
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        long topHandle = this.topHandle();
        return GTK.gtk_widget_get_sensitive(topHandle);
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        boolean selection = GTK.GTK4 ? GTK.gtk_toggle_button_get_active(this.handle) : GTK3.gtk_toggle_tool_button_get_active(this.handle);
        return selection;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(topHandle, allocation);
        return allocation.width;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        return this.parent.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        return this.parent.gtk_button_release_event(widget, event);
    }

    @Override
    long gtk_clicked(long widget) {
        long eventPtr;
        Event event = new Event();
        if ((this.style & 4) != 0 && (eventPtr = GTK3.gtk_get_current_event()) != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Control.fixGdkEventTypeValues(eventType);
            long topHandle = this.topHandle();
            switch (eventType) {
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    boolean isArrow = false;
                    if (widget == this.arrowHandle) {
                        isArrow = true;
                        topHandle = widget;
                        OS.g_signal_handlers_block_matched(widget, 16, 0, 0, 0L, 0L, 8L);
                        GTK.gtk_toggle_button_set_active(widget, false);
                        OS.g_signal_handlers_unblock_matched(widget, 16, 0, 0, 0L, 0L, 8L);
                    }
                    if (!isArrow) break;
                    event.detail = 4;
                    GtkAllocation allocation = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(topHandle, allocation);
                    event.x = DPIUtil.autoScaleDown(allocation.x);
                    if ((this.style & 0x8000000) != 0) {
                        event.x = DPIUtil.autoScaleDown(this.parent.getClientWidth() - allocation.width) - event.x;
                    }
                    event.y = DPIUtil.autoScaleDown(allocation.y + allocation.height);
                }
            }
            this.gdk_event_free(eventPtr);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    long gtk_create_menu_proxy(long widget) {
        int index;
        ImageList imageList;
        if (GTK.GTK4) {
            return 0L;
        }
        byte[] buffer = Converter.wcsToMbcs("menu-id", true);
        if (this.proxyMenuItem != 0L) {
            GTK3.gtk_tool_item_set_proxy_menu_item(widget, buffer, this.proxyMenuItem);
            return 1L;
        }
        Image image = this.currentImage;
        if (image != null && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(image)) != -1) {
            long menuLabel;
            long boxHandle;
            long surface = imageList.getSurface(index);
            byte[] label = null;
            int[] showImages = new int[]{1};
            label = this.text == null || this.text.length() == 0 ? (showImages[0] == 0 && this.toolTipText != null ? Converter.wcsToMbcs(this.toolTipText, true) : new byte[1]) : Converter.wcsToMbcs(this.text, true);
            long menuItem = GTK3.gtk_menu_item_new();
            if (menuItem == 0L) {
                this.error(2);
            }
            if ((boxHandle = this.gtk_box_new(0, false, 6)) == 0L) {
                this.error(2);
            }
            if ((menuLabel = GTK3.gtk_accel_label_new(label)) == 0L) {
                this.error(2);
            }
            GTK.gtk_label_set_xalign(this.labelHandle, 0.0f);
            GTK.gtk_widget_set_halign(this.labelHandle, 0);
            long menuImage = GTK3.gtk_image_new_from_surface(surface);
            if (menuImage == 0L) {
                this.error(2);
            }
            GTK3.gtk_container_add(boxHandle, menuImage);
            this.gtk_box_pack_end(boxHandle, menuLabel, true, true, 0);
            GTK3.gtk_container_add(menuItem, boxHandle);
            GTK3.gtk_tool_item_set_proxy_menu_item(widget, buffer, menuItem);
            this.proxyMenuItem = GTK3.gtk_tool_item_get_proxy_menu_item(widget, buffer);
            OS.g_signal_connect(menuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_enter_notify_event(long widget, long event) {
        int index;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(widget, event);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.hotImage)) != -1 && this.imageHandle != 0L) {
            if (GTK.GTK4) {
                long pixbuf = ImageList.createPixbuf(this.hotImage);
                long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                OS.g_object_unref(pixbuf);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, texture);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(index));
            }
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 4: {
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                if (eventButton[0] != 3) break;
                double[] eventRX = new double[1];
                double[] eventRY = new double[1];
                GDK.gdk_event_get_root_coords(gdkEvent, eventRX, eventRY);
                this.parent.showMenu((int)eventRX[0], (int)eventRY[0]);
            }
        }
        return 0L;
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        this.parent.hasChildFocus = true;
        this.parent.currentFocusItem = this;
        this.parent.sendFocusEvent(15);
        return 0L;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        this.parent.hasChildFocus = false;
        this.parent.sendFocusEvent(16);
        return 0L;
    }

    @Override
    long gtk_leave_notify_event(long widget, long event) {
        this.parent.gtk_leave_notify_event(widget, event);
        if (this.drawHotImage) {
            int index;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.image != null && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.image)) != -1 && this.imageHandle != 0L) {
                if (GTK.GTK4) {
                    long pixbuf = ImageList.createPixbuf(this.image);
                    long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                    OS.g_object_unref(pixbuf);
                    GTK4.gtk_image_set_from_paintable(this.imageHandle, texture);
                } else {
                    GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(index));
                }
            }
        }
        return 0L;
    }

    @Override
    long gtk_map(long widget) {
        this.parent.fixZOrder();
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        if (GTK.GTK4) {
            if ((this.style & 4) != 0) {
                if (this.arrowHandle != 0L) {
                    long clickGesture = GTK4.gtk_gesture_click_new();
                    OS.g_signal_connect(clickGesture, OS.pressed, this.display.gesturePressReleaseProc, 100L);
                    GTK4.gtk_widget_add_controller(this.arrowHandle, clickGesture);
                }
                OS.g_signal_connect_closure(GTK4.gtk_widget_get_first_child(this.handle), OS.clicked, this.display.getClosure(8), false);
            } else {
                OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
            }
            long focusController = GTK4.gtk_event_controller_focus_new();
            GTK4.gtk_widget_add_controller(this.handle, focusController);
            GTK.gtk_event_controller_set_propagation_phase(focusController, 3);
            OS.g_signal_connect(focusController, OS.enter, this.display.focusProc, 86L);
            OS.g_signal_connect(focusController, OS.leave, this.display.focusProc, 87L);
            long motionController = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(this.handle, motionController);
            GTK.gtk_event_controller_set_propagation_phase(motionController, 3);
            OS.g_signal_connect(motionController, OS.enter, this.display.enterMotionProc, 95L);
            OS.g_signal_connect(motionController, OS.leave, this.display.leaveProc, 96L);
            long clickController = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.handle, clickController);
            OS.g_signal_connect(clickController, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            this.eventHandle = GTK3.gtk_bin_get_child(this.handle);
            if ((this.style & 4) != 0) {
                long list = GTK3.gtk_container_get_children(this.eventHandle);
                this.eventHandle = OS.g_list_nth_data(list, 0);
                OS.g_list_free(list);
                if (this.arrowHandle != 0L) {
                    OS.g_signal_connect_closure(this.arrowHandle, OS.clicked, this.display.getClosure(8), false);
                }
            }
            OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
            OS.g_signal_connect_closure(this.handle, OS.create_menu_proxy, this.display.getClosure(83), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            int mask = 32518;
            GTK3.gtk_widget_add_events(this.eventHandle, mask);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        if (!this.mapHooked) {
            long topHandle = this.topHandle();
            OS.g_signal_connect_closure_by_id(topHandle, this.display.signalIds[30], 0, this.display.getClosure(30), true);
            this.mapHooked = true;
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        ToolItem[] tabList = this.parent._getTabItemList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        int index = this.parent.indexOf(this);
        if (index == 0) {
            return true;
        }
        ToolItem previous = this.parent.getItem(index - 1);
        return (previous.getStyle() & 2) != 0;
    }

    @Override
    void register() {
        super.register();
        if (this.eventHandle != 0L) {
            this.display.addWidget(this.eventHandle, this);
        }
        if (this.arrowHandle != 0L) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.eventHandle = 0L;
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.arrowHandle = 0L;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.currentFocusItem == this) {
            this.parent.currentFocusItem = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
        this.disposeDefault();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle itemRect = this.getBounds();
            this.control.setSize(itemRect.width, itemRect.height);
            this.resizeHandle(itemRect.width, itemRect.height);
            Rectangle rect = this.control.getBounds();
            rect.x = itemRect.x + (itemRect.width - rect.width) / 2;
            rect.y = itemRect.y + (itemRect.height - rect.height) / 2;
            this.control.setLocation(rect.x, rect.y);
        }
    }

    void resizeHandle(int width, int height) {
        GTK.gtk_widget_set_size_request(this.handle, width, height);
        GtkRequisition requisition = new GtkRequisition();
        this.parent.gtk_widget_get_preferred_size(this.handle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, allocation);
        allocation.width = width;
        allocation.height = height;
        this.gtk_widget_size_allocate(this.handle, allocation, -1);
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        Color oldColor = this.background;
        this.background = color;
        if (Objects.equals(oldColor, this.background)) {
            return;
        }
        this.updateStyle();
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
        if (control != null) {
            this.parent.fixZOrder();
            if (!this.mapHooked) {
                OS.g_signal_connect_closure_by_id(this.topHandle(), this.display.signalIds[30], 0, this.display.getClosure(30), true);
                this.mapHooked = true;
            }
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (this.disabledImage == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        if (image != null) {
            if (!this.enabled) {
                this._setImage(image);
            }
            this.disposeDefault();
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        long topHandle = this.topHandle();
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        GTK.gtk_widget_set_sensitive(topHandle, enabled);
        this._setEnabledOrDisabledImage();
    }

    private void _setEnabledOrDisabledImage() {
        if (!this.enabled) {
            if (this.disabledImage == null) {
                if (this.defaultDisableImage == null && this.image != null) {
                    this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
                }
                this._setImage(this.defaultDisableImage);
            } else {
                this._setImage(this.disabledImage);
            }
        }
        if (this.enabled && this.image != null) {
            this._setImage(this.image);
        }
    }

    boolean setFocus() {
        return GTK.gtk_widget_child_focus(this.handle, 0);
    }

    void setFontDescription(long font) {
        if (this.labelHandle != 0L) {
            this.setFontDescription(this.labelHandle, font);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        Color oldColor = this.foreground;
        this.foreground = color;
        if (Objects.equals(oldColor, this.foreground)) {
            return;
        }
        this.updateStyle();
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (this.hotImage == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.disposeDefault();
        if (!this.enabled && this.disabledImage != image && this.disabledImage != null) {
            return;
        }
        this._setEnabledOrDisabledImage();
    }

    private void disposeDefault() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }

    void _setImage(Image image) {
        if ((this.style & 2) != 0) {
            return;
        }
        this.currentImage = image;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
            if (GTK.GTK4) {
                GTK.gtk_widget_show(this.imageHandle);
                long pixbuf = ImageList.createPixbuf(image);
                long texture = GDK.gdk_texture_new_for_pixbuf(pixbuf);
                OS.g_object_unref(pixbuf);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, texture);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, imageList.getSurface(imageIndex));
            }
        } else if (GTK.GTK4) {
            GTK4.gtk_image_clear(this.imageHandle);
            GTK.gtk_widget_hide(this.imageHandle);
        } else {
            GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
        }
        this.recreateMenuProxy();
        this.parent.relayout();
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, dir);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        if (GTK.GTK4) {
            GTK.gtk_toggle_button_set_active(this.handle, selected);
        } else {
            GTK3.gtk_toggle_tool_button_set_active(this.handle, selected);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    @Override
    boolean setTabItemFocus(boolean next) {
        return this.setFocus();
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0L) {
            return;
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        if (GTK.GTK4) {
            GTK.gtk_widget_show(this.labelHandle);
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        } else {
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        }
        if ((this.parent.style & 0x20000) != 0 && !GTK.GTK4) {
            GTK3.gtk_tool_item_set_is_important(this.handle, !string.isEmpty());
        }
        this.recreateMenuProxy();
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string || this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        if (this.parent.toolTipText == null) {
            if (GTK.GTK4) {
                this.setToolTipText(this.handle, string);
            } else {
                long child = GTK3.gtk_bin_get_child(this.handle);
                if ((this.style & 4) != 0) {
                    long list = GTK3.gtk_container_get_children(child);
                    child = OS.g_list_nth_data(list, 0);
                    OS.g_list_free(list);
                    if (this.arrowHandle != 0L) {
                        this.setToolTipText(this.arrowHandle, string);
                    }
                }
                this.setToolTipText(child != 0L ? child : this.handle, string);
            }
        }
        this.toolTipText = string;
        this.recreateMenuProxy();
    }

    public void setWidth(int width) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(width));
    }

    void setWidthInPixels(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        this.resizeHandle(width, (this.parent.style & 0x200) != 0 ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int index) {
        if (GTK.GTK4) {
            if (index == 0) {
                GTK4.gtk_box_prepend(this.parent.handle, this.handle);
            } else if (index < 0) {
                GTK4.gtk_box_append(this.parent.handle, this.handle);
            } else {
                long sibling = GTK4.gtk_widget_get_first_child(this.parent.handle);
                while (sibling != 0L) {
                    if (index == 1) {
                        GTK4.gtk_box_insert_child_after(this.parent.handle, this.handle, sibling);
                        break;
                    }
                    --index;
                    sibling = GTK4.gtk_widget_get_next_sibling(sibling);
                }
            }
        } else {
            if (this.handle != 0L) {
                GTK.gtk_widget_show(this.handle);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_show(this.imageHandle);
            }
            GTK3.gtk_toolbar_insert(this.parent.handle, this.handle, index);
        }
    }

    void updateStyle() {
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            if ((this.style & 4) != 0) {
                long box = GTK3.gtk_bin_get_child(this.handle);
                long list = GTK3.gtk_container_get_children(box);
                int i = 0;
                while (i < 2) {
                    long child = OS.g_list_nth_data(list, i);
                    long context = GTK.gtk_widget_get_style_context(child);
                    GTK.gtk_style_context_add_provider(context, this.provider, 600);
                    ++i;
                }
                OS.g_list_free(list);
            } else {
                long child = GTK3.gtk_bin_get_child(this.handle);
                long context = GTK.gtk_widget_get_style_context(child);
                GTK.gtk_style_context_add_provider(context, this.provider, 600);
            }
            OS.g_object_unref(this.provider);
        }
        Object css = "";
        css = this.foreground != null ? (String)css + "button { color: " + this.display.gtk_rgba_to_css_string(this.foreground.handle) + "; }" : (String)css + this.parent.cssForeground;
        if (this.background != null) {
            css = (String)css + "button { background-image: none; background-color: " + this.display.gtk_rgba_to_css_string(this.background.handle) + "; }";
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs((String)css, true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs((String)css, true), -1L, null);
        }
    }

    @Override
    String getNameText() {
        String nameText = super.getNameText();
        Object data = this.getData();
        if (data != null) {
            return "text: '" + nameText + "', data: " + String.valueOf(data);
        }
        return nameText;
    }

    @Override
    long dpiChanged(long object, long arg0) {
        super.dpiChanged(object, arg0);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        if (this.hotImage != null) {
            this.hotImage.internal_gtk_refreshImageForZoom();
            this.setHotImage(this.hotImage);
        }
        if (this.disabledImage != null) {
            this.disabledImage.internal_gtk_refreshImageForZoom();
            this.setDisabledImage(this.disabledImage);
        }
        return 0L;
    }

    private void recreateMenuProxy() {
        if (!((this.style & 4) == 0 && this.proxyMenuItem == 0L || GTK.GTK4)) {
            this.proxyMenuItem = 0L;
            this.proxyMenuItem = GTK3.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
        }
    }
}

