/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.RGBColorDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class ResourceManager {
    private List<Runnable> disposeExecs = null;

    public abstract Device getDevice();

    public abstract <R> R create(DeviceResourceDescriptor<R> var1);

    public abstract <R> void destroy(DeviceResourceDescriptor<R> var1);

    public final <R> R get(DeviceResourceDescriptor<R> descriptor) {
        R cached = this.find(descriptor);
        return cached != null ? cached : this.create(descriptor);
    }

    @Deprecated(since="3.31")
    public final Image createImage(ImageDescriptor descriptor) {
        Assert.isNotNull((Object)descriptor);
        return this.create(descriptor);
    }

    public final Image createImageWithDefault(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return this.getDefaultImage();
        }
        try {
            return this.create(descriptor);
        }
        catch (DeviceResourceException | SWTException e) {
            Policy.getLog().log((IStatus)Status.warning((String)("The image could not be loaded: " + String.valueOf(descriptor)), (Throwable)e));
            return this.getDefaultImage();
        }
    }

    protected abstract Image getDefaultImage();

    @Deprecated(since="3.31")
    public final void destroyImage(ImageDescriptor descriptor) {
        this.destroy(descriptor);
    }

    @Deprecated(since="3.31")
    public final Color createColor(ColorDescriptor descriptor) {
        return this.create(descriptor);
    }

    public final Color createColor(RGB descriptor) {
        return this.create(new RGBColorDescriptor(descriptor));
    }

    public final void destroyColor(RGB descriptor) {
        this.destroy(new RGBColorDescriptor(descriptor));
    }

    @Deprecated(since="3.31")
    public final void destroyColor(ColorDescriptor descriptor) {
        this.destroy(descriptor);
    }

    @Deprecated(since="3.31")
    public final Font createFont(FontDescriptor descriptor) {
        return this.create(descriptor);
    }

    @Deprecated(since="3.31")
    public final void destroyFont(FontDescriptor descriptor) {
        this.destroy(descriptor);
    }

    public void dispose() {
        Runnable[] execs;
        if (this.disposeExecs == null) {
            return;
        }
        RuntimeException foundException = null;
        Runnable[] runnableArray = execs = this.disposeExecs.toArray(new Runnable[this.disposeExecs.size()]);
        int n = execs.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable exec = runnableArray[n2];
            try {
                exec.run();
            }
            catch (RuntimeException e) {
                if (foundException == null) {
                    foundException = e;
                }
                foundException.addSuppressed(e);
            }
            ++n2;
        }
        if (foundException != null) {
            throw foundException;
        }
    }

    public abstract <R> R find(DeviceResourceDescriptor<R> var1);

    public void disposeExec(Runnable r) {
        Assert.isNotNull((Object)r);
        if (this.disposeExecs == null) {
            this.disposeExecs = new ArrayList<Runnable>();
        }
        this.disposeExecs.add(r);
    }

    public void cancelDisposeExec(Runnable r) {
        Assert.isNotNull((Object)r);
        if (this.disposeExecs == null) {
            return;
        }
        this.disposeExecs.remove(r);
        if (this.disposeExecs.isEmpty()) {
            this.disposeExecs = null;
        }
    }
}

